#include <stdio.h>
#include <fstream.h>
#include "vuCommandLineTool.h"

vuCommandLineTool::vuCommandLineTool()
{
  m_argc = 0;
  m_argv = NULL;
}

vuCommandLineTool::vuCommandLineTool(int argc, const char ** argv)
{
  m_argc = argc;
  m_argv = NULL;
  if (m_argc > 0) {
    m_argv = new vuString[m_argc];
    for (int i=0; i<m_argc; i++) {
      m_argv[i] = argv[i];
    }
  }
}

vuCommandLineTool::vuCommandLineTool(const vuCommandLineTool &other)
{
  throw "vuCommandLineTool::copyConstructor is not implemented";
}

vuCommandLineTool::~vuCommandLineTool()
{
  if (m_argv != NULL) {
    delete [] m_argv;
    m_argv = NULL;
  }
}

bool vuCommandLineTool::hasParameter(const char *param)
{
  return (indexForParamter(vuString(param)) >= 0);
}

vuString vuCommandLineTool::stringForParameter(const char *param)
{
  vuString str(param);

  if (!str.hasPrefix("--")) return vuString("");

  int i = indexForParamter(param);

  if (i>0) {
    str = m_argv[i];
    dword i, cnt = str.getLength();

    for (i=2; (i<cnt); i++) {
      if (str[i] == '=') {
	i++;
	break;
      }
    }
    return str.substr(i,cnt);
  }
  return vuString("");
}

float vuCommandLineTool::floatForParameter(const char *param)
{
  vuString str    = stringForParameter(vuString(param));
  float    result = 0.0;

  sscanf(str.c_str(), "%f", &result);

  return result;
}

int vuCommandLineTool::intForParameter(const char *param)
{
  vuString str    = stringForParameter(vuString(param));
  int      result = 0;

  sscanf(str.c_str(), "%d", &result);

  return result;
}


word vuCommandLineTool::numberOfNonParameters()
{
  bool isValid;
  return numberOfNonParameters(isValid);
}

word vuCommandLineTool::numberOfNonParameters(bool &isValid)
{
  word result  = 0;
  bool isFound = false; // is first '-' found?

  isValid = true;
  for (word i=m_argc-1; i>0; i--) {
    if (!isFound && !m_argv[i].hasPrefix("-")) {
      result++;
      continue;
    }
    isFound = true;
    if (!m_argv[i].hasPrefix("-")) {
      isValid = false;
      break;
    }
  }
  return result;
}

vuString vuCommandLineTool::getNonParameter(const dword idx)
{
    dword nums = numberOfNonParameters();

    return getArgument(m_argc-nums+idx);
}


vuString vuCommandLineTool::getArgument(word idx)
{
  if (idx >= m_argc) idx = m_argc -1;
  return m_argv[idx];
}


bool vuCommandLineTool::fileExists(const vuString &fileName)
{
  bool     result;
  ifstream ifp;

#ifdef IS_NOCREATE_NEEDED
  ifp.open(fileName.c_str(), ios::in|ios::binary|ios::nocreate);
#else
  // The nocreate is not available on the IRIX boxes that we were compiling
  // this code on, so we had to remove this part from
  ifp.open(fileName, ios::in|ios::binary);
#endif
  result = ifp.is_open();
  if (result) ifp.close();
  
  return result;
}

vuString vuCommandLineTool::toolName()
{
  return (m_argc > 0) ? m_argv[0].getLastPathComponent() : vuString("toolname");
}

/* ------------------------------------------------------------------------- */
/* --- private methods ----------------------------------------------------- */
/* ------------------------------------------------------------------------- */

// returns index of found param, otherwise -1
int vuCommandLineTool::indexForParamter(const vuString &param)
{
  vuString str = param;
  bool isLong = false; // true for "--"paramters
  if (str.isEmpty()) return -1;
  if (str.hasPrefix("--")) {
    isLong = true;
    str += "=";
  }
  for (int i=1; i<m_argc; i++) {
    if (m_argv[i] == param) return i;
    if (isLong && m_argv[i].hasPrefix(str)) return i;
  }
  return -1;
}
