
#ifndef _VUARCBALL_H_
#define _VUARCBALL_H_

#include "vuCamera.h"

//! Provides arc ball control for a vuCamera
/*! An arc ball is a useful way to control the rotation of 
    an object. Therefore the surface points of a Halfsphere are mapped
    to the screen. If the mouse is dragged over the screen the rotation
    behaves like a ball which surface is touched by a moving finger.
*/
class vuArcBall
{
 public:
    //! default constructor
    vuArcBall();

    //! attach a camera
    void attachCamera(vuCamera & camera);

    //! set extensions of window
    /*! This is necessairy to provide a proper mapping of cartesian 
        coordinates to surface points of a spere 
    */
    void setWinSize(int maxX, int maxY);

    //! set a center around which the camera rotates
    void setCenter(vuVector & center);

    //!Turn camera
    /*! old (ox,oy)  and new (nx,ny) position of mouse pointer are used to perform
        a rotation of the camera around a central point
     */
    void turn(int ox,int oy,int nx,int ny);
    
 protected:
    //!Translate point into unit-sphere coordinate
    vuVector spherePoint(int px,int py); //

    int m_Winx; //!< This is the width of the window
    int m_Winy; //!< This is the height of the window.
    vuVector m_Center; //!< This is the vector that points to the center of this window
    vuCamera *m_Camera; //!< This is the camera associated with this window.
};

#endif
