#include "vuSimpleTypes.h"
#include <math.h>
#include "vuMatrix.h"
#include "vuVector.h"
#include "vuArcBall.h"

//! default constructor
vuArcBall::vuArcBall()
{
  m_Camera = 0;
}

//! attach a camera
void vuArcBall::attachCamera(vuCamera & camera)
{
  m_Camera = &camera;
}

//! set extensions of window
/*! This is necessairy to provide a proper mapping of cartesian 
  coordinates to surface points of a spere 
*/
void vuArcBall::setWinSize(int maxX, int maxY)
{
  m_Winx = maxX;
  m_Winy = maxY;
}

//! set a center around which the camera rotates
void vuArcBall::setCenter(vuVector & center)
{
  m_Center = center;
}


// The following two functions come from the FOX Toolkit (class FXGLViewer)
// Translate point into unit-sphere coordinate
vuVector vuArcBall::spherePoint(int px,int py)
{
  double d,t,screenmin;
  vuVector v;
  if(m_Winx>m_Winy)
    screenmin=m_Winy;
  else
    screenmin=m_Winx;
  if(screenmin<=0.0) return vuVector(0,0,0);
  
  v[0]=(float)(2.0*(px-0.5*m_Winx)/screenmin);
  v[1]=(float)(2.0*(0.5*m_Winy-py)/screenmin);
  d=v[0]*v[0]+v[1]*v[1];
  if(d<0.75){
    v[2]=(float)sqrt(1.0-d);
  }
  else if(d<3.0){
    d=1.7320508008-sqrt(d);
    t=1.0-d*d;
    if(t<0.0) t=0.0;
    v[2]=(float)(1.0-sqrt(t));
  }
  else{
    v[2]=0.0;
  }
  return v.makeUnit();
} 

// Turn camera
void vuArcBall::turn(int ox,int oy,int nx,int ny)
{
  if(m_Camera == 0 || (nx==ox && ny==oy) ) return;
  vuVector oldsp,newsp;
  oldsp=spherePoint(ox,oy);
  newsp=spherePoint(nx,ny);
  float ac = newsp.dot(oldsp);
  float phi = acos(ac)*M_1_PI*180;
  vuVector axis = (oldsp.cross(newsp)).mul(vuVector(-1,-1,1));

  if(axis.norm2()<0.00001) return;

  //axis.makeUnit();
  vuMatrix cam = m_Camera->getViewMat();
  axis = cam*axis;	//xform axis to camera coordinate system
  axis.makeUnit();
  vuMatrix m;
  m.makeRotate(axis, phi);

  m_Camera->transform(m);
} 

