#include <iostream>

#include "MarchingCubesData.h"

#define DEBUG_MODE 0
#include "debug.h"

int main(void)
{
	MCMesh * _mesh = new MCMesh();
	int tri, idx;

	//	Triangle I:
	DEBUG4("Triangle I:\n");
	tri = _mesh->AddTriangle();
	vuVector v(1.0, 1.0, 1.0);
	_mesh->AddVertex(0, 0, 0, 0, tri, v);	// 0
	v = vuVector(1.0, 3.0, 1.0);
	_mesh->AddVertex(0, 1, 0, 0, tri, v);	// 1
	v = vuVector(3.0, 1.0, 1.0);
	_mesh->AddVertex(1, 0, 0, 0, tri, v);	// 2

	//	Triangle II:
	DEBUG4("Triangle II:\n");
	tri = _mesh->AddTriangle();
	idx = _mesh->GetVertex(1, 0, 0, 0);
	assert(idx != -1);
	_mesh->AddVertex(idx, tri);		// 2
	idx = _mesh->GetVertex(0, 1, 0, 0);
	assert(idx != -1);
	_mesh->AddVertex(idx, tri);		// 1
	idx = _mesh->GetVertex(1, 1, 0, 0);
	assert(idx == -1);
	v = vuVector(3.0, 3.0, 1.0);
	_mesh->AddVertex(1, 1, 0, 0, tri, v);	// 3

	//	Triangle III:
	DEBUG4("Triangle III:\n");
	tri = _mesh->AddTriangle();
	idx = _mesh->GetVertex(1, 0, 0, 0);
	assert(idx != -1);
	_mesh->AddVertex(idx, tri);		// 2
	idx = _mesh->GetVertex(1, 1, 0, 0);
	assert(idx != -1);
	_mesh->AddVertex(idx, tri);		// 3
	idx = _mesh->GetVertex(1, 0, 1, 0);
	assert(idx == -1);
	v = vuVector(3.0, 1.0, 3.0);
	_mesh->AddVertex(1, 0, 1, 0, tri, v);	// 4

	//	Triangle IV:
	DEBUG4("Triangle IV:\n");
	tri = _mesh->AddTriangle();
	idx = _mesh->GetVertex(1, 0, 1, 0);
	assert(idx != -1);
	_mesh->AddVertex(idx, tri);		// 4
	idx = _mesh->GetVertex(1, 1, 0, 0);
	assert(idx != -1);
	_mesh->AddVertex(idx, tri);		// 3
	idx = _mesh->GetVertex(1, 1, 1, 0);
	assert(idx == -1);
	v = vuVector(3.0, 3.0, 3.0);
	_mesh->AddVertex(1, 1, 1, 0, tri, v);	// 5

	_mesh->DebugPrint();
	_mesh->prepare();

	delete _mesh;

	return 0;
}
