/**
 * @file	MarchingCubesBase.cpp
 * @brief	Declaration of the MarchingCubesBase member functions.
 *
 * @author	Markus Trenkwalder
 * @date	26. Jun 2004, 13:00:13
 * @version	0.0.1
 *
 * $id : $
 *
 */


#include <assert.h>

#include "MarchingCubesBase.h"

// Actual mode is: 8
#define DEBUG_MODE 8
//#define DEBUG_DEST
#include "General/vuMarchingCubes/debug.h"


const GLfloat MarchingCubesBase::_vertOffset[8][3] = { // {{{
	{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 1.0, 0.0}, {0.0, 1.0, 0.0},
	{0.0, 0.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 1.0}, {0.0, 1.0, 1.0}
}; // }}}


const int MarchingCubesBase::_marchingCubesTable[256][16] = { // {{{
	{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 8, 3, 9, 8, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 3, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{9, 2, 10, 0, 2, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{2, 8, 3, 2, 10, 8, 10, 9, 8, -1, -1, -1, -1, -1, -1, -1},
	{3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 11, 2, 8, 11, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 9, 0, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 11, 2, 1, 9, 11, 9, 8, 11, -1, -1, -1, -1, -1, -1, -1},
	{3, 10, 1, 11, 10, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 10, 1, 0, 8, 10, 8, 11, 10, -1, -1, -1, -1, -1, -1, -1},
	{3, 9, 0, 3, 11, 9, 11, 10, 9, -1, -1, -1, -1, -1, -1, -1},
	{9, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 3, 0, 7, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 1, 9, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 1, 9, 4, 7, 1, 7, 3, 1, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 10, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{3, 4, 7, 3, 0, 4, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1},
	{9, 2, 10, 9, 0, 2, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1},
	{2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4, -1, -1, -1, -1},
	{8, 4, 7, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{11, 4, 7, 11, 2, 4, 2, 0, 4, -1, -1, -1, -1, -1, -1, -1},
	{9, 0, 1, 8, 4, 7, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1},
	{4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1, -1, -1, -1, -1},
	{3, 10, 1, 3, 11, 10, 7, 8, 4, -1, -1, -1, -1, -1, -1, -1},
	{1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4, -1, -1, -1, -1},
	{4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3, -1, -1, -1, -1},
	{4, 7, 11, 4, 11, 9, 9, 11, 10, -1, -1, -1, -1, -1, -1, -1},
	{9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{9, 5, 4, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 5, 4, 1, 5, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{8, 5, 4, 8, 3, 5, 3, 1, 5, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 10, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{3, 0, 8, 1, 2, 10, 4, 9, 5, -1, -1, -1, -1, -1, -1, -1},
	{5, 2, 10, 5, 4, 2, 4, 0, 2, -1, -1, -1, -1, -1, -1, -1},
	{2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8, -1, -1, -1, -1},
	{9, 5, 4, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 11, 2, 0, 8, 11, 4, 9, 5, -1, -1, -1, -1, -1, -1, -1},
	{0, 5, 4, 0, 1, 5, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1},
	{2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5, -1, -1, -1, -1},
	{10, 3, 11, 10, 1, 3, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1},
	{4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10, -1, -1, -1, -1},
	{5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3, -1, -1, -1, -1},
	{5, 4, 8, 5, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1},
	{9, 7, 8, 5, 7, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{9, 3, 0, 9, 5, 3, 5, 7, 3, -1, -1, -1, -1, -1, -1, -1},
	{0, 7, 8, 0, 1, 7, 1, 5, 7, -1, -1, -1, -1, -1, -1, -1},
	{1, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{9, 7, 8, 9, 5, 7, 10, 1, 2, -1, -1, -1, -1, -1, -1, -1},
	{10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3, -1, -1, -1, -1},
	{8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2, -1, -1, -1, -1},
	{2, 10, 5, 2, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1},
	{7, 9, 5, 7, 8, 9, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1},
	{9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11, -1, -1, -1, -1},
	{2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7, -1, -1, -1, -1},
	{11, 2, 1, 11, 1, 7, 7, 1, 5, -1, -1, -1, -1, -1, -1, -1},
	{9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11, -1, -1, -1, -1},
	{5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0, -1},
	{11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0, -1},
	{11, 10, 5, 7, 11, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 3, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{9, 0, 1, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 8, 3, 1, 9, 8, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1},
	{1, 6, 5, 2, 6, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 6, 5, 1, 2, 6, 3, 0, 8, -1, -1, -1, -1, -1, -1, -1},
	{9, 6, 5, 9, 0, 6, 0, 2, 6, -1, -1, -1, -1, -1, -1, -1},
	{5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8, -1, -1, -1, -1},
	{2, 3, 11, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{11, 0, 8, 11, 2, 0, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1},
	{0, 1, 9, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1},
	{5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11, -1, -1, -1, -1},
	{6, 3, 11, 6, 5, 3, 5, 1, 3, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6, -1, -1, -1, -1},
	{3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9, -1, -1, -1, -1},
	{6, 5, 9, 6, 9, 11, 11, 9, 8, -1, -1, -1, -1, -1, -1, -1},
	{5, 10, 6, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 3, 0, 4, 7, 3, 6, 5, 10, -1, -1, -1, -1, -1, -1, -1},
	{1, 9, 0, 5, 10, 6, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1},
	{10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4, -1, -1, -1, -1},
	{6, 1, 2, 6, 5, 1, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7, -1, -1, -1, -1},
	{8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6, -1, -1, -1, -1},
	{7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9, -1},
	{3, 11, 2, 7, 8, 4, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1},
	{5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11, -1, -1, -1, -1},
	{0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1},
	{9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6, -1},
	{8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6, -1, -1, -1, -1},
	{5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11, -1},
	{0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7, -1},
	{6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9, -1, -1, -1, -1},
	{10, 4, 9, 6, 4, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 10, 6, 4, 9, 10, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1},
	{10, 0, 1, 10, 6, 0, 6, 4, 0, -1, -1, -1, -1, -1, -1, -1},
	{8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10, -1, -1, -1, -1},
	{1, 4, 9, 1, 2, 4, 2, 6, 4, -1, -1, -1, -1, -1, -1, -1},
	{3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4, -1, -1, -1, -1},
	{0, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{8, 3, 2, 8, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1},
	{10, 4, 9, 10, 6, 4, 11, 2, 3, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6, -1, -1, -1, -1},
	{3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10, -1, -1, -1, -1},
	{6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1, -1},
	{9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3, -1, -1, -1, -1},
	{8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1, -1},
	{3, 11, 6, 3, 6, 0, 0, 6, 4, -1, -1, -1, -1, -1, -1, -1},
	{6, 4, 8, 11, 6, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{7, 10, 6, 7, 8, 10, 8, 9, 10, -1, -1, -1, -1, -1, -1, -1},
	{0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10, -1, -1, -1, -1},
	{10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0, -1, -1, -1, -1},
	{10, 6, 7, 10, 7, 1, 1, 7, 3, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7, -1, -1, -1, -1},
	{2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9, -1},
	{7, 8, 0, 7, 0, 6, 6, 0, 2, -1, -1, -1, -1, -1, -1, -1},
	{7, 3, 2, 6, 7, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7, -1, -1, -1, -1},
	{2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7, -1},
	{1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11, -1},
	{11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1, -1, -1, -1, -1},
	{8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6, -1},
	{0, 9, 1, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0, -1, -1, -1, -1},
	{7, 11, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{3, 0, 8, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 1, 9, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{8, 1, 9, 8, 3, 1, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1},
	{10, 1, 2, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 10, 3, 0, 8, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1},
	{2, 9, 0, 2, 10, 9, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1},
	{6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8, -1, -1, -1, -1},
	{7, 2, 3, 6, 2, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{7, 0, 8, 7, 6, 0, 6, 2, 0, -1, -1, -1, -1, -1, -1, -1},
	{2, 7, 6, 2, 3, 7, 0, 1, 9, -1, -1, -1, -1, -1, -1, -1},
	{1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6, -1, -1, -1, -1},
	{10, 7, 6, 10, 1, 7, 1, 3, 7, -1, -1, -1, -1, -1, -1, -1},
	{10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8, -1, -1, -1, -1},
	{0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7, -1, -1, -1, -1},
	{7, 6, 10, 7, 10, 8, 8, 10, 9, -1, -1, -1, -1, -1, -1, -1},
	{6, 8, 4, 11, 8, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{3, 6, 11, 3, 0, 6, 0, 4, 6, -1, -1, -1, -1, -1, -1, -1},
	{8, 6, 11, 8, 4, 6, 9, 0, 1, -1, -1, -1, -1, -1, -1, -1},
	{9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6, -1, -1, -1, -1},
	{6, 8, 4, 6, 11, 8, 2, 10, 1, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6, -1, -1, -1, -1},
	{4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9, -1, -1, -1, -1},
	{10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3, -1},
	{8, 2, 3, 8, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1},
	{0, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8, -1, -1, -1, -1},
	{1, 9, 4, 1, 4, 2, 2, 4, 6, -1, -1, -1, -1, -1, -1, -1},
	{8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1, -1, -1, -1, -1},
	{10, 1, 0, 10, 0, 6, 6, 0, 4, -1, -1, -1, -1, -1, -1, -1},
	{4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3, -1},
	{10, 9, 4, 6, 10, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 9, 5, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 3, 4, 9, 5, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1},
	{5, 0, 1, 5, 4, 0, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1},
	{11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5, -1, -1, -1, -1},
	{9, 5, 4, 10, 1, 2, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1},
	{6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5, -1, -1, -1, -1},
	{7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2, -1, -1, -1, -1},
	{3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6, -1},
	{7, 2, 3, 7, 6, 2, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1},
	{9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7, -1, -1, -1, -1},
	{3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0, -1, -1, -1, -1},
	{6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8, -1},
	{9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7, -1, -1, -1, -1},
	{1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4, -1},
	{4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10, -1},
	{7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10, -1, -1, -1, -1},
	{6, 9, 5, 6, 11, 9, 11, 8, 9, -1, -1, -1, -1, -1, -1, -1},
	{3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5, -1, -1, -1, -1},
	{0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11, -1, -1, -1, -1},
	{6, 11, 3, 6, 3, 5, 5, 3, 1, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6, -1, -1, -1, -1},
	{0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10, -1},
	{11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5, -1},
	{6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3, -1, -1, -1, -1},
	{5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2, -1, -1, -1, -1},
	{9, 5, 6, 9, 6, 0, 0, 6, 2, -1, -1, -1, -1, -1, -1, -1},
	{1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8, -1},
	{1, 5, 6, 2, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6, -1},
	{10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0, -1, -1, -1, -1},
	{0, 3, 8, 5, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{10, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{11, 5, 10, 7, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{11, 5, 10, 11, 7, 5, 8, 3, 0, -1, -1, -1, -1, -1, -1, -1},
	{5, 11, 7, 5, 10, 11, 1, 9, 0, -1, -1, -1, -1, -1, -1, -1},
	{10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1, -1, -1, -1, -1},
	{11, 1, 2, 11, 7, 1, 7, 5, 1, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11, -1, -1, -1, -1},
	{9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7, -1, -1, -1, -1},
	{7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2, -1},
	{2, 5, 10, 2, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1},
	{8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5, -1, -1, -1, -1},
	{9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2, -1, -1, -1, -1},
	{9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2, -1},
	{1, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 7, 0, 7, 1, 1, 7, 5, -1, -1, -1, -1, -1, -1, -1},
	{9, 0, 3, 9, 3, 5, 5, 3, 7, -1, -1, -1, -1, -1, -1, -1},
	{9, 8, 7, 5, 9, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{5, 8, 4, 5, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1},
	{5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0, -1, -1, -1, -1},
	{0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5, -1, -1, -1, -1},
	{10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4, -1},
	{2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8, -1, -1, -1, -1},
	{0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11, -1},
	{0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5, -1},
	{9, 4, 5, 2, 11, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4, -1, -1, -1, -1},
	{5, 10, 2, 5, 2, 4, 4, 2, 0, -1, -1, -1, -1, -1, -1, -1},
	{3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9, -1},
	{5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2, -1, -1, -1, -1},
	{8, 4, 5, 8, 5, 3, 3, 5, 1, -1, -1, -1, -1, -1, -1, -1},
	{0, 4, 5, 1, 0, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5, -1, -1, -1, -1},
	{9, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 11, 7, 4, 9, 11, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1},
	{0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11, -1, -1, -1, -1},
	{1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11, -1, -1, -1, -1},
	{3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4, -1},
	{4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2, -1, -1, -1, -1},
	{9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3, -1},
	{11, 7, 4, 11, 4, 2, 2, 4, 0, -1, -1, -1, -1, -1, -1, -1},
	{11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4, -1, -1, -1, -1},
	{2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9, -1, -1, -1, -1},
	{9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7, -1},
	{3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10, -1},
	{1, 10, 2, 8, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 9, 1, 4, 1, 7, 7, 1, 3, -1, -1, -1, -1, -1, -1, -1},
	{4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1, -1, -1, -1, -1},
	{4, 0, 3, 7, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{4, 8, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{9, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{3, 0, 9, 3, 9, 11, 11, 9, 10, -1, -1, -1, -1, -1, -1, -1},
	{0, 1, 10, 0, 10, 8, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1},
	{3, 1, 10, 11, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 2, 11, 1, 11, 9, 9, 11, 8, -1, -1, -1, -1, -1, -1, -1},
	{3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9, -1, -1, -1, -1},
	{0, 2, 11, 8, 0, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{3, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{2, 3, 8, 2, 8, 10, 10, 8, 9, -1, -1, -1, -1, -1, -1, -1},
	{9, 10, 2, 0, 9, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8, -1, -1, -1, -1},
	{1, 10, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{1, 3, 8, 9, 1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 9, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},
	{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}
}; // }}}


const int MarchingCubesBase::_edgeConnect[12][2] = { // {{{
	{0,1}, {1,2}, {2,3}, {3,0},
	{4,5}, {5,6}, {6,7}, {7,4},
	{0,4}, {1,5}, {2,6}, {3,7}
}; // }}}


const int MarchingCubesBase::_edgeSizeConnect[12] = { // {{{
	0, 1, 0, 1,
	0, 1, 0, 1,
	2, 2, 2, 2
}; // }}}


const int MarchingCubesBase::_edgeMapping[12][3][3][3] = { // {{{
	{ //  0:		{{{
	  {// -x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    {  6, -1,  2 },	// -y
	    { -1, -1, -1 },	//  0
	    {  4, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  1:		{{{
	  {// -x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    {  5, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    {  7,  3, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  2:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    {  6, -1, -1 },	//  0
	    {  4,  0, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  3:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    {  5,  1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    {  7, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  4:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1,  6,  2 },	// -y
	    { -1, -1,  0 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  5:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1,  1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1,  7,  3 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  6:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1,  2 },	//  0
	    { -1,  4,  0 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  7:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1,  5,  1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1,  3 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  8:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, 10, -1 },	// -y
	    { -1,  9, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, 11, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ //  9:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, 10, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, 11, -1 },	// -y
	    { -1,  8, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	}, //			}}}
	{ // 10:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1,  9, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, 11, -1 },	//  0
	    { -1,  8, -1 }	//  y
	  }
	}, //			}}}
	{ // 11:		{{{
	  {// -x:
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, 10, -1 },	//  0
	    { -1,  9, -1 }	//  y
	  },
	  {//  0
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1,  8, -1 }	//  y
	  },
	  {//  x
	   // -z   0   z
	    { -1, -1, -1 },	// -y
	    { -1, -1, -1 },	//  0
	    { -1, -1, -1 }	//  y
	  }
	} //			}}}
}; // }}}


const GLfloat MarchingCubesBase::_edgeDir[12][3] = { // {{{
        {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, -1.0, 0.0},
        {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, -1.0, 0.0},
        {0.0, 0.0, 1.0}, {0.0, 0.0, 1.0}, { 0.0, 0.0, 1.0}, {0.0,  0.0, 1.0}
}; // }}}


const int MarchingCubesBase::_edgeFlags[256] = { // {{{
        0x000, 0x109, 0x203, 0x30a, 0x406, 0x50f, 0x605, 0x70c,
	0x80c, 0x905, 0xa0f, 0xb06, 0xc0a, 0xd03, 0xe09, 0xf00, 
        0x190, 0x099, 0x393, 0x29a, 0x596, 0x49f, 0x795, 0x69c,
	0x99c, 0x895, 0xb9f, 0xa96, 0xd9a, 0xc93, 0xf99, 0xe90, 
        0x230, 0x339, 0x033, 0x13a, 0x636, 0x73f, 0x435, 0x53c,
	0xa3c, 0xb35, 0x83f, 0x936, 0xe3a, 0xf33, 0xc39, 0xd30, 
        0x3a0, 0x2a9, 0x1a3, 0x0aa, 0x7a6, 0x6af, 0x5a5, 0x4ac,
	0xbac, 0xaa5, 0x9af, 0x8a6, 0xfaa, 0xea3, 0xda9, 0xca0, 
        0x460, 0x569, 0x663, 0x76a, 0x066, 0x16f, 0x265, 0x36c,
	0xc6c, 0xd65, 0xe6f, 0xf66, 0x86a, 0x963, 0xa69, 0xb60, 
        0x5f0, 0x4f9, 0x7f3, 0x6fa, 0x1f6, 0x0ff, 0x3f5, 0x2fc,
	0xdfc, 0xcf5, 0xfff, 0xef6, 0x9fa, 0x8f3, 0xbf9, 0xaf0, 
        0x650, 0x759, 0x453, 0x55a, 0x256, 0x35f, 0x055, 0x15c,
	0xe5c, 0xf55, 0xc5f, 0xd56, 0xa5a, 0xb53, 0x859, 0x950, 
        0x7c0, 0x6c9, 0x5c3, 0x4ca, 0x3c6, 0x2cf, 0x1c5, 0x0cc,
	0xfcc, 0xec5, 0xdcf, 0xcc6, 0xbca, 0xac3, 0x9c9, 0x8c0, 
        0x8c0, 0x9c9, 0xac3, 0xbca, 0xcc6, 0xdcf, 0xec5, 0xfcc,
	0x0cc, 0x1c5, 0x2cf, 0x3c6, 0x4ca, 0x5c3, 0x6c9, 0x7c0, 
        0x950, 0x859, 0xb53, 0xa5a, 0xd56, 0xc5f, 0xf55, 0xe5c,
	0x15c, 0x055, 0x35f, 0x256, 0x55a, 0x453, 0x759, 0x650, 
        0xaf0, 0xbf9, 0x8f3, 0x9fa, 0xef6, 0xfff, 0xcf5, 0xdfc,
	0x2fc, 0x3f5, 0x0ff, 0x1f6, 0x6fa, 0x7f3, 0x4f9, 0x5f0, 
        0xb60, 0xa69, 0x963, 0x86a, 0xf66, 0xe6f, 0xd65, 0xc6c,
	0x36c, 0x265, 0x16f, 0x066, 0x76a, 0x663, 0x569, 0x460, 
        0xca0, 0xda9, 0xea3, 0xfaa, 0x8a6, 0x9af, 0xaa5, 0xbac,
	0x4ac, 0x5a5, 0x6af, 0x7a6, 0x0aa, 0x1a3, 0x2a9, 0x3a0, 
        0xd30, 0xc39, 0xf33, 0xe3a, 0x936, 0x83f, 0xb35, 0xa3c,
	0x53c, 0x435, 0x73f, 0x636, 0x13a, 0x033, 0x339, 0x230, 
        0xe90, 0xf99, 0xc93, 0xd9a, 0xa96, 0xb9f, 0x895, 0x99c,
	0x69c, 0x795, 0x49f, 0x596, 0x29a, 0x393, 0x099, 0x190, 
        0xf00, 0xe09, 0xd03, 0xc0a, 0xb06, 0xa0f, 0x905, 0x80c,
	0x70c, 0x605, 0x50f, 0x406, 0x30a, 0x203, 0x109, 0x000
}; // }}}


MarchingCubesBase::MarchingCubesBase() // {{{
: _origin1(1.0), _origin2(1.0), _origin3(1.0),
  _data(0),
  _gd(NULL),
  _valueRangeAdjusted(false),
  _progCB(0),
  _histoCB(0),
  _mesh(0),
  _theCube(0),
  _cube(0)
{
	DEBUG0("MarchingCubesBase::MarchingCubesBase(MCGlobalData *gd)\n");
} /* }}} MarchingCubesBase::MarchingCubesBase(MCGlobalData *gd) */


MarchingCubesBase::~MarchingCubesBase() // {{{
{
	DEBUGD("virtual MarchingCubesBase::~MarchingCubesBase()\n");
	if (_data) delete _data;
	if (_progCB) delete _progCB;
	if (_histoCB) delete _histoCB;
	if (_mesh) delete _mesh;
} /* }}} MarchingCubesBase::~MarchingCubesBase() */


//! \todo The way the border is drawn isn't beautyfull. We should use _vertOffset and _origin*.
void MarchingCubesBase::glRenderFrame() // {{{
{
	DEBUG0("void MarchingCubesBase::glRenderFrame()\n");
	assert(_gd != NULL);
	glPushMatrix();
		glTranslatef(_origin1, _origin2, _origin3);
		drawHorCylinder(1,   0.0, _gd->frameRadius, (float)_size[2]*_gd->cubeSize[2]);
		drawHorCylinder(0,  90.0, _gd->frameRadius, (float)_size[0]*_gd->cubeSize[0]);
		drawHorCylinder(4, 180.0, _gd->frameRadius, (float)_size[2]*_gd->cubeSize[2]);
		drawHorCylinder(5, 270.0, _gd->frameRadius, (float)_size[0]*_gd->cubeSize[0]);
		drawHorCylinder(2,   0.0, _gd->frameRadius, (float)_size[2]*_gd->cubeSize[2]);
		drawHorCylinder(3,  90.0, _gd->frameRadius, (float)_size[0]*_gd->cubeSize[0]);
		drawHorCylinder(7, 180.0, _gd->frameRadius, (float)_size[2]*_gd->cubeSize[2]);
		drawHorCylinder(6, 270.0, _gd->frameRadius, (float)_size[0]*_gd->cubeSize[0]);
		drawVertCylinder(0, _gd->frameRadius, (float)_size[1]*_gd->cubeSize[1]);
		drawVertCylinder(1, _gd->frameRadius, (float)_size[1]*_gd->cubeSize[1]);
		drawVertCylinder(4, _gd->frameRadius, (float)_size[1]*_gd->cubeSize[1]);
		drawVertCylinder(5, _gd->frameRadius, (float)_size[1]*_gd->cubeSize[1]);
		for(int i = 0; i < 8; ++i) {
			drawCorner(i, _gd->frameRadius);
		}
	glPopMatrix();
} /* }}} void MarchingCubesBase::glRenderFrame() */


//! \todo Handling the origin correct and in a unique way!
void MarchingCubesBase::glRender() // {{{
{
	DEBUG0("void MarchingCubesBase::glRender()\n");
	if (_gd->cullMode) {
		glEnable(GL_CULL_FACE);
		glCullFace(_gd->cullMode);
	} else {
		glDisable(GL_CULL_FACE);
	}

	if (_gd->cubeBrowser) {
		glPushMatrix();
			glTranslatef(_origin1, _origin2, _origin3);
			// Draw spots for every set bit:
			for(int i = 0; i < 8; ++i) {
				if (!(_gd->cube&(1<<i))) drawSpot(i);
				//if ((_gd->cube&(1<<i))) drawSpot(i);
			}
			bool tp = _gd->termProgress;
			_gd->termProgress = false;
			drawTriangles();
			_gd->termProgress = tp;
		glPopMatrix();
	} else {
		glPushMatrix();
			glTranslatef(_origin1, _origin2, _origin3);
			//GLint mode = _gd->drawLines ? GL_LINE_LOOP : GL_TRIANGLES;
			if (_gd->drawObject) _mesh->render();
		glPopMatrix();
		if (!_gd->drawObject) {
			GLUquadric* quad = gluNewQuadric();
			glPushMatrix();
				gluCylinder(quad, (float)_size[1]/50.0, (float)_size[1]/50.0, (float)_size[2]/5.0, 36, 10);
				glTranslatef(0.0, 0.0, (float)_size[2]/5.0);
				gluCylinder(quad, (float)_size[1]/20.0, 0.0, _size[2]/10.0, 36, 10);
				gluDisk(quad, (float)_size[1]/50.0, (float)_size[1]/20.05, 36, 2);
			glPopMatrix();
			glPushMatrix();
				glRotatef(-90.0, 1.0, 0.0, 0.0);
				gluCylinder(quad, (float)_size[1]/50.0, (float)_size[1]/50.0, (float)_size[2]/5.0, 36, 10);
				glTranslatef(0.0, 0.0, (float)_size[2]/5.0);
				gluCylinder(quad, (float)_size[1]/20.0, 0.0, _size[2]/10.0, 36, 10);
				gluDisk(quad, (float)_size[1]/50.0, (float)_size[1]/20.05, 36, 2);
			glPopMatrix();
			glPushMatrix();
				glRotatef(90.0, 0.0, 1.0, 0.0);
				gluCylinder(quad, (float)_size[1]/50.0, (float)_size[1]/50.0, (float)_size[2]/5.0, 36, 10);
				glTranslatef(0.0, 0.0, (float)_size[2]/5.0);
				gluCylinder(quad, (float)_size[1]/20.0, 0.0, _size[2]/10.0, 36, 10);
				gluDisk(quad, (float)_size[1]/50.0, (float)_size[1]/20.05, 36, 2);
			glPopMatrix();
			glutSolidSphere((float)_size[1]/50.0, 36, 36);
		}
	}

	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);
} /* }}} void MarchingCubesBase::glRender() */


void MarchingCubesBase::Size(int sz1, int sz2, int sz3) // {{{
{
	DEBUG0("void MarchingCubesBase::Size("<<sz1<<", "<<sz2<<", "<<sz3<<")\n");
	assert(_gd);
	//! Setup internal geometry
	_size[0] = sz1;
	_size[1] = sz2;
	_size[2] = sz3;
	Origin((float)-_size[0]/2.0, (float)-_size[1]/2.0, (float)-_size[2]/2.0);
	_gd->normalsLength = (float)this->maxSize()/10.0;
	//! and finally create the data array:
	if (_data) { delete [] _data; _data = 0; }	// but first we should delete the old data.
	_data = new int[sz1*sz2*sz3];
	_gd->termProgress = (maxSize()>=128);
} /* }}} void MarchingCubesBase::Size(int sz1, int sz2, int sz3) */


int MarchingCubesBase::maxSize() // {{{
{
	DEBUG0("int MarchingCubesBase::maxSize()\n");
	int max = (_size[0] > _size[1]) ? _size[0] : _size[1];
	return (max > _size[2]) ? max : _size[2];
} /* }}} int MarchingCubesBase::maxSize() */


long long MarchingCubesBase::numVertices() // {{{
{
	DEBUG0("long long MarchingCubesBase::numVertices()\n");
	if (_mesh) return _mesh->numVertices();
	return 0;
} // }}} long long MarchingCubesBase::numVertices()


long long MarchingCubesBase::numTriangles() // {{{
{
	DEBUG0("long long MarchingCubesBase::numTriangles()\n");
	if (_mesh) return _mesh->numTriangles();
	return 0;
} // }}} long long MarchingCubesBase::numTriangles()


long long MarchingCubesBase::numIndices() // {{{
{
	DEBUG0("long long MarchingCubesBase::numIndices()\n");
	if (_mesh) return _mesh->numIndices();
	return 0;
} // }}} long long MarchingCubesBase::numIndices()


void MarchingCubesBase::Origin(float or1, float or2, float or3) // {{{
{
	DEBUG0("void MarchingCubesBase::Origin("<<or1<<", "<<or2<<", "<<or3<<")\n");
	_origin1 = or1;
	_origin2 = or2;
	_origin3 = or3;
} /* }}} void MarchingCubesBase::Origin(int or1, int or2, int or3) */


void MarchingCubesBase::drawHorCylinder(int pos, float angle, float r, float l) // {{{
{
	DEBUG0("void MarchingCubesBase::void drawHorCylinder(int pos, float angle, float r, float l)\n");
	assert(_gd);
	GLUquadric* quad = gluNewQuadric();
	glPushMatrix();
		glTranslated((float)_size[0]*_vertOffset[pos][0]*_gd->cubeSize[0],
			     (float)_size[1]*_vertOffset[pos][1]*_gd->cubeSize[1],
			     (float)_size[2]*_vertOffset[pos][2]*_gd->cubeSize[2]);
		glRotated(angle, 0.0, 1.0, 0.0);
		gluCylinder(quad, r, r, l, 36, 10);
	glPopMatrix();
} /* }}} void MarchingCubesBase::void drawHorCylinder(int pos, float angle, float r, float l) */


void MarchingCubesBase::drawVertCylinder(int pos, float r, float l) // {{{
{
	GLUquadric* quad = gluNewQuadric();
	glPushMatrix();
		glTranslated((float)_size[0]*_vertOffset[pos][0]*_gd->cubeSize[0],
			     (float)_size[1]*_vertOffset[pos][1]*_gd->cubeSize[1],
			     (float)_size[2]*_vertOffset[pos][2]*_gd->cubeSize[2]);
		glRotated(-90.0, 1.0, 0.0, 0.0);
		gluCylinder(quad, r, r, l, 36, 10);
	glPopMatrix();
} /* }}} void MarchingCubesBase::drawVertCylinder(int pos, float r, float l) */


void MarchingCubesBase::drawCorner(int pos, float r) // {{{
{
	glPushMatrix();
		glTranslated((float)_size[0]*_vertOffset[pos][0]*_gd->cubeSize[0],
			     (float)_size[1]*_vertOffset[pos][1]*_gd->cubeSize[1],
			     (float)_size[2]*_vertOffset[pos][2]*_gd->cubeSize[2]);
		glutSolidSphere(r, 36, 36);
	glPopMatrix();
} /* }}} void MarchingCubesBase::drawCorner(int pos, float r) */


void MarchingCubesBase::drawSpot(int pos) // {{{
{
	float r = maxSize()/20.0;
	glPushMatrix();
		glTranslatef((float)_size[0]*_vertOffset[pos][0]*_gd->cubeSize[0],
			     (float)_size[1]*_vertOffset[pos][1]*_gd->cubeSize[1],
			     (float)_size[2]*_vertOffset[pos][2]*_gd->cubeSize[2]);
		glutSolidSphere(r, 36, 36);
	glPopMatrix();
} /* }}} void MarchingCubesBase::drawSpot(int pos) */


void MarchingCubesBase::drawTriangles() // {{{
{
	int n = 0;

	if (_theCube != _gd->cube) {
		if (_cube) delete _cube;
		_cube = new MCMesh(_gd);
		DEBUG7("_gd->cube = "<<_gd->cube<<"\n");
		int triangle = -1;
		while((_marchingCubesTable[_gd->cube][n] != -1) && (n < 16)) {
			if (!(n%3)) {
				DEBUG7("adding a triangle ...\n");
				triangle = _cube->AddTriangle(_gd->cube);
			}
			int edge = _marchingCubesTable[_gd->cube][n];
			int vertex;
			if ((vertex = _cube->GetVertex(0, 0, 0, edge)) != -1) {
				DEBUG7("adding existing vertex "<<vertex
				       <<" to triangle "<<triangle<<"\n");
				_cube->AddVertex(vertex, triangle);
			} else {
				DEBUG7("adding new vertex to triangle "<<triangle<<"\n");
				int start = _edgeConnect[edge][0];
				vuVector vert((float)_size[0]*_vertOffset[start][0],
					      (float)_size[1]*_vertOffset[start][1],
					      (float)_size[2]*_vertOffset[start][2]);
				DEBUG7("vert = ("<<vert[0]<<", "<<vert[1]<<", "<<vert[2]<<")\n");
				vuVector dir(_edgeDir[edge][0],
					     _edgeDir[edge][1],
					     _edgeDir[edge][2]);
				DEBUG7("dir = ("<<dir[0]<<", "<<dir[1]<<", "<<dir[2]<<")\n");
				vert += dir*(_size[_edgeSizeConnect[edge]]*0.5);
				DEBUG7("vert = ("<<vert[0]<<", "<<vert[1]<<", "<<vert[2]<<")\n");
				_cube->AddVertex(0, 0, 0, edge, triangle, vert);
			}
			++n;
		}
		_theCube = _gd->cube;
	}

	_cube->render();
} /* }}} void MarchingCubesBase::drawTriangles() */


int MarchingCubesBase::getCubeType(int x, int y, int z) // {{{
{
	DEBUG0("int MarchingCubesBase::getCubeType(int x="<<x<<", int y="<<y<<", int z="<<z<<")\n");
	DEBUG4("x = "<<x<<", y = "<<y<<", z = "<<z<<"\n");
	assert(x<(int)_size[0] && y<(int)_size[1] && z<(int)_size[2]);
	int result = 0;
	for(int i = 0; i < 8; ++i) {
		int idx = MCB_IDX(x+(int)_vertOffset[i][0],
				  y+(int)_vertOffset[i][1],
				  z+(int)_vertOffset[i][2]);
		DEBUG4("_data["<<idx<<"]="<<_data[idx]<<", thres="<<_gd->thres<<"\n");
		//int val = ((float)_data[idx]>=_gd->thres) ? 1 : 0;
		int val = ((float)_data[idx]>=_gd->thres) ? 0 : 1;
		DEBUG4("val = "<<val<<", i = "<<i<<", (val<<i)="<<(val<<i)<<"\n");
		result += (val<<i);
		if (!_valueRangeAdjusted) {
			_gd->valueMin = (_data[idx]<_gd->valueMin) ? _data[idx] : _gd->valueMin;
			_gd->valueMax = (_data[idx]>_gd->valueMax) ? _data[idx] : _gd->valueMax;
		}
	}
	return result;
} // }}} int MarchingCubesBase::getCubeType(int x, int y, int z)


float MarchingCubesBase::valueAt(float px, float py, float pz) // {{{
{
	DEBUG0("float MarchingCubesBase::valueAt(float x, float y, float z)\n");
	DEBUG8("position: "<<px<<", "<<py<<", "<<pz<<"\n");
	int ix = (int)px;
	int iy = (int)py;
	int iz = (int)pz;
	DEBUG8("cube position: "<<ix<<", "<<iy<<", "<<iz<<"\n");
	float x = px - (float)ix;
	float y = py - (float)iy;
	float z = pz - (float)iz;
	DEBUG8("delta position: "<<x<<", "<<y<<", "<<z<<"\n");
	return	_data[MCB_IDX(ix  , iy  , iz  )] * (1-x) * (1-y) * (1-z) +
		_data[MCB_IDX(ix+1, iy  , iz  )] * (  x) * (1-y) * (1-z) +
		_data[MCB_IDX(ix  , iy+1, iz  )] * (1-x) * (  y) * (1-z) +
		_data[MCB_IDX(ix  , iy  , iz+1)] * (1-x) * (1-y) * (  z) +
		_data[MCB_IDX(ix+1, iy  , iz+1)] * (  x) * (1-y) * (  z) +
		_data[MCB_IDX(ix  , iy+1, iz+1)] * (1-x) * (  y) * (  z) +
		_data[MCB_IDX(ix+1, iy+1, iz  )] * (  x) * (  y) * (1-z) +
		_data[MCB_IDX(ix+1, iy+1, iz+1)] * (  x) * (  y) * (  z);
} // }}} float MarchingCubesBase::valueAt(float x, float y, float z)


inline vuVector MarchingCubesBase::calcVertex(int x, int y, int z, int edge) // {{{
{
	DEBUG0("vuVector MarchingCubesBase::calcVertex(int x, int y, int z, int edge)\n");

	DEBUG5("x = "<<x<<", y = "<<y<<", z = "<<z<<", edge = "<<edge
	       <<", c0 = "<<_edgeConnect[edge][0]<<", c1 = "<<_edgeConnect[edge][1]
	       <<", idx0 = "<<MCB_IDX(x+(int)_vertOffset[_edgeConnect[edge][0]][0],
				      y+(int)_vertOffset[_edgeConnect[edge][0]][1],
				      z+(int)_vertOffset[_edgeConnect[edge][0]][2])
	       <<", idx1 = "<<MCB_IDX(x+(int)_vertOffset[_edgeConnect[edge][1]][0],
				      y+(int)_vertOffset[_edgeConnect[edge][1]][1],
				      z+(int)_vertOffset[_edgeConnect[edge][1]][2])<<"\n");

	/*
	vuVector v0(((float)x+_vertOffset[_edgeConnect[edge][0]][0])*_gd->cubeSize[0],
		    ((float)y+_vertOffset[_edgeConnect[edge][0]][1])*_gd->cubeSize[1],
		    ((float)z+_vertOffset[_edgeConnect[edge][0]][2])*_gd->cubeSize[2]);
	vuVector v1(((float)x+_vertOffset[_edgeConnect[edge][1]][0])*_gd->cubeSize[0],
		    ((float)y+_vertOffset[_edgeConnect[edge][1]][1])*_gd->cubeSize[1],
		    ((float)z+_vertOffset[_edgeConnect[edge][1]][2])*_gd->cubeSize[2]);
	*/
	vuVector v0(((float)x+_vertOffset[_edgeConnect[edge][0]][0]),
		    ((float)y+_vertOffset[_edgeConnect[edge][0]][1]),
		    ((float)z+_vertOffset[_edgeConnect[edge][0]][2]));
	vuVector v1(((float)x+_vertOffset[_edgeConnect[edge][1]][0]),
		    ((float)y+_vertOffset[_edgeConnect[edge][1]][1]),
		    ((float)z+_vertOffset[_edgeConnect[edge][1]][2]));
	float val0 = _data[MCB_IDX(x+(int)_vertOffset[_edgeConnect[edge][0]][0],
				   y+(int)_vertOffset[_edgeConnect[edge][0]][1],
				   z+(int)_vertOffset[_edgeConnect[edge][0]][2])];
	float val1 = _data[MCB_IDX(x+(int)_vertOffset[_edgeConnect[edge][1]][0],
				   y+(int)_vertOffset[_edgeConnect[edge][1]][1],
				   z+(int)_vertOffset[_edgeConnect[edge][1]][2])];
	vuVector e = v1 - v0;
	float eLen = e.norm(), dist = 0;
	DEBUG5("val0 = "<<val0<<", val1 = "<<val1<<", _gd->thres = "<<_gd->thres<<", eLen = "<<eLen<<"\n");
	if (val0 == val1) {
		dist = eLen / 2.0;
	} else if (val0 < val1) {
		assert(val0<=_gd->thres && _gd->thres<=val1);
		dist = (_gd->thres-val0)/(val1-val0)*eLen;
	} else {
		assert(val1<=_gd->thres && _gd->thres<=val0);
		dist = eLen-((_gd->thres-val1)/(val0-val1)*eLen);
	}
	DEBUG5("dist = "<<dist<<"\n");
	vuVector result = v0 + e.makeUnit()*dist;
	return result;
} // }}} vuVector MarchingCubesBase::calcVertex(int x, int y, int z, int edge)


void MarchingCubesBase::marchCubes() // {{{
{
	DEBUG0("void MarchingCubesBase::marchCubes()\n");
	assert(_gd != NULL);
	if (_histoCB) _histoCB->Clear();
	StartProgress();
	SetProgressText("Calculating mesh (i.e. marching cubes):");
 	//! Because cubes of type 0 and 255 are so much, we do a delayed update for this types for ourself.
	int type0 = 0;
	int type255 = 0;
	int x = 0, y = 0, z = 0;
	if (!_valueRangeAdjusted) {
		_gd->valueMin = 0xfffffff;
		_gd->valueMax = 0;
	}
	try {
		if (_mesh) delete _mesh;
		_mesh = new MCMesh(_gd, _progCB);
		for(z = 0; z < _size[2]-1; ++z) {
			for(y = 0; y < _size[1]-1; ++y)
			for(x = 0; x < _size[0]-1; ++x) {
				//! First we calculate the type of this cube:
				int type = getCubeType(x, y, z);
				DEBUG5("type = "<<type<<"\n");
				if (_histoCB && type!=0 && type!=255) _histoCB->Inc(type);
				if (type==0) ++type0;
				if (type==255) ++type255;
				if (type != 0 && type != 255) {
					int triangle = -1;
					//! For every edge in the _marchingCubesTable we have to:
					int vertNr = 0;
					while (vertNr<16 && _marchingCubesTable[type][vertNr]!=-1) {
						int edgeNr = _marchingCubesTable[type][vertNr];
						DEBUG5("vertNr = "<<vertNr<<", edgeNr = "<<edgeNr<<"\n");
						int vertex;
						//! First we have to create an triangle:
						if ((vertNr%3) == 0)
							triangle = _mesh->AddTriangle(type);
						DEBUG5("triangle = "<<triangle<<"\n");
						//! We first lookup the vertex in the data structure:
						if ((vertex=_mesh->GetVertex(x,y,z,edgeNr)) != -1) {
							//! We have found one so we use it.
							_mesh->AddVertex(vertex, triangle);
						} else {
							//! Nope, there is none.
							//! We have to create one.
							vuVector v = calcVertex(x, y, z, edgeNr);
							DEBUG6("Adding vector ("<<v[0]<<", "
							       <<v[1]<<", "<<v[2]<<")\n");
							_mesh->AddVertex(x,y,z,edgeNr,triangle,v);
						}
						++vertNr; // Don't forget to jump to the next entry!
					}
				}
			}
			if (_gd->termProgress)
				std::cerr << ((float)z/(float)_size[2]*100.0) << "% marched.\n";
			if (_histoCB) {
				_histoCB->Inc(0,   type0);   type0   = 0;
				_histoCB->Inc(255, type255); type255 = 0;
			}
			UpdateProgress(int((float)z/(float)_size[2]*100.0));
		}
		_valueRangeAdjusted = true;
		if (_histoCB) _histoCB->Flush();
		EndProgress();
		_mesh->prepare();
	} catch (...) {
		MC_FAIL_EXIT(  "Error while marching through the cubes.\n"
			     <<"Actual mesh memory usage is: "<<_gd->meshSize<<".\n"
			     <<"Actual index in the data is: "<<x<<", "<<y<<", "<<z<<".\n", -1);
	}
} // }}} void MarchingCubesBase::marchCubes()


void MarchingCubesBase::SetProgressCallback(MCBProgressCallback* cb) // {{{
{
	DEBUG0("void MarchingCubesBase::SetProgressCallback(MCBProgressCallback* cb)\n");
	_progCB = cb;
} // }}} void MarchingCubesBase::SetProgressCallback(MCBProgressCallback* cb)


void MarchingCubesBase::SetHistoCallback(MCBHistoCallback* cb) // {{{
{
	DEBUG0("void MarchingCubesBase::SetHistoCallback(MCBHistoCallback* cb)\n");
	_histoCB = cb;
} // }}} void MarchingCubesBase::SetHistoCallback(MCBHistoCallback* cb)


void MarchingCubesBase::SetProgressText(const char* txt) // {{{
{
	DEBUG0("void MarchingCubesBase::SetProgressText(const char* txt="<<txt<<")\n");
	if (_progCB) _progCB->SetText(txt);
} // }}} void MarchingCubesBase::SetProgressText(const char* txt)


void MarchingCubesBase::StartProgress() // {{{
{
	DEBUG0("void MarchingCubesBase::StartProgress()\n");
	if (_progCB) _progCB->Start();
} // }}} void MarchingCubesBase::StartProgress()


void MarchingCubesBase::UpdateProgress(int v) // {{{
{
	DEBUG0("void MarchingCubesBase::UpdateProgress(int v="<<v<<")\n");
	if (_progCB) _progCB->Update(v);
} // }}} void MarchingCubesBase::UpdateProgress(int v)


void MarchingCubesBase::EndProgress() // {{{
{
	DEBUG0("void MarchingCubesBase::EndProgress()\n");
	if (_progCB) _progCB->End();
} // }}} void MarchingCubesBase::EndProgress()


// vim:fdm=marker:fdc=2:tw=100
