/**
 * @file	MCGlobalData.h
 *
 * Defines a data structure holding elements used by several classes.
 *
 * @author	Markus Trenkwalder
 * @date	08. Nov 2004, 20:09:55
 * @version	0.0.1
 *
 * $Id: MCGlobalData.h,v 1.4 2004/11/22 22:55:51 maxx Exp $
 *
 */
#ifndef __MCGLOBALDATA_H__	// {{{
#define __MCGLOBALDATA_H__

#include "vuVector.h"

/**
 * This structure collects variables used in several classes.
 */
struct MCGlobalData { // {{{

	/**
	 * The Threshold. This value is set in vuMarchingCubes through the m_thres slider and read
	 * in MarchingCubesBase::marchCubes.
	 */
	float thres;
	/**
	 * Lowest value in the data. This value is set by MarchingCubesBase::getCubeType and used to
	 * adjust the threshold slider vuMarchingCubes::m_thres.
	 */
	int valueMin;
	//! Highest value in the data (see \ref valueMin).
	int valueMax;

	/**
	 * Size of a cube. The default value is \c (1.0,1.0,1.0). This value is change by three
	 * sliders in vuMarchingCubes and used in MarchingCubesBase::marchCubes.
	 */
	float cubeSize[3];

	//! The smoothing factor.
	float smooth;
	//! The recursion level for the smoothing algorithm.
	unsigned short recursions;
	//! If true, the data and index arrayes are recompiled.
	bool compileData;

	/**
	 * Radius of the tubes and spheres building the frame. This value is set by the
	 * vuMarchingCubes::m_frameRadius slider and read by MarchingCubesBase::glRenderFrame.
	 */
	float frameRadius;

	/**
	 * If true, a whireframe is drawn. This value is set by vuMarchingCubes::m_drawLines and
	 * used in several drawing functions MarchingCubesBase.
	 */
	bool drawLines;

	/**
	 * If true the user can browse the cubes. This value is set by
	 * vuMarchingCubes::m_cubeEnable and used in MarchingCubesBase::glRender.
	 */
	bool cubeBrowser;
	/**
	 * The cube type to be drawn by the cube browser. This value also indicates the cube type to
	 * highlight.
	 */
	int cube;

	//! Holds the actual CullFace mode or 0 if faces should not be culled.
	int cullMode;
	/**
	 * Holds the mode for the line drawing mode. If no lines should be drawn, it is set to
	 * zero.
	 */
	int linesMode;

	/**
	 * If set to true the normals should be drawn. This value is set by
	 * vuMarchingCubes::m_drawNormals and used in MCMesh.
	 */
	bool drawNormals;
	/**
	 * The length of the normals. This value is set by vuMarchingCubes::m_drawNormalsSize and
	 * used in MCMesh when calculating the normals array.
	 */
	float normalsLength;
	/**
	 * If true, the normals arra in MCMech is recompiled. This should be set when normalsLength
	 * is changed and will be reset in MCMesh::_compileNormalsArray.
	 */
	bool compileNormals;

	/**
	 * The object color for a specific cube type. This value is set by
	 * vuMarchingCubes::m_objectColor and used in MCMesh to set up the color array used by \ref
	 * glDrawElements.
	 */
	vuVector objectColor[256];
	/**
	 * If set to \c true, the color for the cube is the same as the object color. If it is
	 * \c false, another color is set for this type.
	 */
	bool isObjectColor[256];
	/**
	 * The color for the lines.
	 */
	vuVector lineColor;
	//! The first selected color.
	vuVector cubeTypeColor1;
	//! The second selected color.
	vuVector cubeTypeColor2;

	//! If true, MCMesh does some statitics on it's size.
	bool doMeshStatistics;
	/**
	 * Mesh size. This is a byte counter counting the memory usage of all dynamic objects of
	 * type MCTriangle and MCVertex.
	 */
	unsigned int meshSize;

	/**
	 * If the frame rate falls below this value, the drawing of the object will be turned of.
	 */
	float fpsThres;
	/**
	 * If true, the object will be drawn. This variable is used for a simple state machine which
	 * turns of the drawing of the object, when the frame rate falls below a certain value.
	 */
	bool drawObject;

	//! If this is true, progress messages are printed to the terminal.
	bool termProgress;

	MCGlobalData();
}; // }}}


#endif /* }}} __MCGLOBALDATA_H__ */


// vim:fdm=marker:fdc=3:tw=100
