/**
 * @file	MCGlobalData.cpp
 *
 * Implementation of the global data structure.
 *
 * @author	Markus Trenkwalder
 * @date	09. Nov 2004, 09:50:02
 * @version	0.0.1
 *
 * $Id: MCGlobalData.cpp,v 1.6 2004/11/23 03:53:37 maxx Exp $
 *
 */
#include "MCGlobalData.h"

#define DEBUG_MODE 99
#include "General/vuMarchingCubes/debug.h"

MCGlobalData::MCGlobalData() // {{{
: thres(100.0),
  valueMin(0),
  valueMax(4095),
  smooth(0.001),
  recursions(1),
  compileData(false),
  frameRadius(0.1),
  drawLines(false),
  cubeBrowser(false),
  cube(255),
  cullMode(0),
  linesMode(0),
  drawNormals(false),
  normalsLength(1.0),
  compileNormals(true),		// initially the normals array should be compiled.
  doMeshStatistics(true),
  meshSize(0),
  fpsThres(3.0),
  drawObject(true),
  termProgress(false)
{
	DEBUG0("MCGlobalData::MCGlobalData()\n");
	cubeSize[0] = cubeSize[1] = cubeSize[2] = 1.0;
	for(int i = 0; i < 256; ++i) {
		isObjectColor[i] = true;
	}
} // }}} MCGlobalData::MCGlobalData()
