/**
 * @file	MCBProgressCallback.h
 *
 * Two abstract classes implemented by vuMarchingCubes to provide access to GUI elements.
 *
 * @author	Markus Trenkwalder
 * @date	16. Nov 2004, 22:22:25
 * @version	0.0.1
 *
 * $id: $
 *
 */


#ifndef __MCBPROGRESSCALLBACK_H__	// {{{ __MCBPROGRESSCALLBACK_H__
#define __MCBPROGRESSCALLBACK_H__


/**
 * This class provides a callback interface for the progress callback object. This callback is used
 * when ever MarchingCubesBase want's to indicate a progress.
 *
 * <strong>The idea</strong>
 *
 * The idea behind this mechanism is to provide an interface to a callback object that is offered to
 * MarchingCubesBase. Whenever MarchingCubesBase wants to indicate a progress. The class that
 * want's to be called can either implement the interface itself or it can use a decorator class
 * that translates the requests to the corresponding class member functions.
 */
class MCBProgressCallback // {{{
{

	public:

		virtual void SetText(const char* txt) = 0;
		virtual void Start() = 0;
		virtual void Update(int val) = 0;
		virtual void End() = 0;

}; // }}} MCBProgressCallback


/**
 * This callback class provides an interface to indicate an update of a histogram. It is used to
 * show a historgram of cube types. For more infromation see class MCBProgressCallback.
 */
class MCBHistoCallback // {{{
{

	public:

		virtual void Clear() = 0;

		virtual void Inc(int idx, int val = 1) = 0;

		virtual void Flush() = 0;

}; // }}} MCBHistoCallback


#endif // }}} __MCBPROGRESSCALLBACK_H__


// vim:fdm=marker:fdc=3:fdl=99:tw=100
