#ifndef __GENERAL_VU_SPHERIC_VIEW_FILTER_FACTORY_H__
#define __GENERAL_VU_SPHERIC_VIEW_FILTER_FACTORY_H__

#include "vuSphericViewFilter.h"
#include "SphericViewFilter/vuSphVwFlt_Blend.h"
#include "vuMisc/vuString.h"

template <int SIZE, class TYPE>
class vuSphericViewFilterFactory
{
 public:
  static vuSphericViewFilter<SIZE,TYPE> *getFilter(dword idx);

  //!creates spherical lightfield filters
  //!\returns a pointer to a newed filter
  static vuSphericViewFilter<SIZE,TYPE> *getFilter(const vuString &filterName);

  static void getFilterNames(vuString* &filterNames, dword &numberOfNames);

};

template class vuSphericViewFilterFactory<1,byte>;
template class vuSphericViewFilterFactory<2,byte>;
template class vuSphericViewFilterFactory<3,byte>;

template class vuSphericViewFilterFactory<1,float>;
template class vuSphericViewFilterFactory<2,float>;
template class vuSphericViewFilterFactory<3,float>;


typedef vuSphericViewFilterFactory<1,byte> vuSphericViewFilterFactory1B;
typedef vuSphericViewFilterFactory<2,byte> vuSphericViewFilterFactory2B;
typedef vuSphericViewFilterFactory<3,byte> vuSphericViewFilterFactory3B;

typedef vuSphericViewFilterFactory<1,float> vuSphericViewFilterFactory1F;
typedef vuSphericViewFilterFactory<2,float> vuSphericViewFilterFactory2F;
typedef vuSphericViewFilterFactory<3,float> vuSphericViewFilterFactory3F;

#endif /* __GENERAL_VU_SPHERIC_VIEW_FILTER_FACTORY_H__ */
