#include "vuSphericViewFilterFactory.h"
#include "SphericViewFilter/vuSphVwFlt_Blend.h"
#include "SphericViewFilter/vuSphVwFlt_Fourier.h"
#include "SphericViewFilter/vuSphVwFlt_Lazy.h"
#include "SphericViewFilter/vuSphVwFlt_Black.h"

template <int S, class T> vuSphericViewFilter<S,T> *
vuSphericViewFilterFactory<S,T>::getFilter(dword idx)
{
  static vuString *filterNames = NULL;
  static dword    count        = 0;
   
  if (filterNames == NULL)
    vuSphericViewFilterFactory<S,T>::getFilterNames(filterNames, count);

  if (idx < count)
    return getFilter(filterNames[idx]);
  else
    return NULL;
}

template <int S, class T> vuSphericViewFilter<S,T> *
vuSphericViewFilterFactory<S,T>::getFilter(const vuString &filterName)
{
  if (filterName == "Blend")
    return new vuSphVwFlt_Blend<S,T>("Blend");
  else if (filterName == "Fourier")
    return new vuSphVwFlt_Fourier<S,T>("Fourier");
  else if (filterName == "Lazy")
    return new vuSphVwFlt_Lazy<S,T>("Lazy");
  else if (filterName == "Black")
    return new vuSphVwFlt_Black<S,T>("Black");
  else
    return NULL;
}

template <int S, class T> void vuSphericViewFilterFactory<S,T>::
getFilterNames(vuString* &filterNames, dword &numberOfNames)
{
  static const dword    count         = 4;
  static const vuString result[count] = { "Blend",
					  "Fourier",
					  "Lazy",
					  "Black" };

  filterNames   = (vuString *)result;
  numberOfNames = count;
}
