#ifndef __GENERAL_VU_SPHERIC_VIEW_FILTER_H__
#define __GENERAL_VU_SPHERIC_VIEW_FILTER_H__

#include "vuFixelMap.h"
#include "vuSphericView.h"
#include "vuCamera/vuCamera.h"
#include "vuMisc/vuFilter.h"
#include "vuMisc/vuProgressHandler.h"

template <int SIZE, class TYPE>
class vuSphericViewFilter : public vuFilter
{
 public:
  vuSphericViewFilter();
  vuSphericViewFilter(const vuString& filterName);

  virtual ~vuSphericViewFilter();

  void setNumberOfViews(dword count);
  dword getNumberOfViews();

  vuSphericView<SIZE,TYPE>** getViews();
  vuSphericView<SIZE,TYPE>*getView(dword i);
  // returns -1, if view is not in filter other the local index
  int getIndexOfView(vuSphericView<SIZE,TYPE> *view);

  void setView(dword idx, vuSphericView<SIZE,TYPE> *view);

  virtual bool needPreprocessing()      = 0;
  virtual bool needViewsForFiltering()  = 0;

  virtual void filter(vuCamera *camera) = 0;
  virtual void preprocess(vuProgressHandler* handler=NULL);
 
  void initOpenGL(); 
  void glResize(dword width, dword height);
  void glRender();


  vuFixelMap<SIZE,TYPE> *getMap();

  void ensureImage(dword width=0, dword height=0);
  
 protected:
  dword                    m_NumberOfViews;
  vuSphericView<SIZE,TYPE> **m_Views;
  vuFixelMap<SIZE,TYPE>    *m_Image;

  dword m_Width;
  dword m_Height;

  void log(const char *msg);
};

template class vuSphericViewFilter<1,byte>;
template class vuSphericViewFilter<2,byte>;
template class vuSphericViewFilter<3,byte>;

template class vuSphericViewFilter<1,float>;
template class vuSphericViewFilter<2,float>;
template class vuSphericViewFilter<3,float>;

typedef vuSphericViewFilter<1,byte> vuSphericViewFilter1B;
typedef vuSphericViewFilter<2,byte> vuSphericViewFilter2B;
typedef vuSphericViewFilter<3,byte> vuSphericViewFilter3B;

typedef vuSphericViewFilter<1,float> vuSphericViewFilter1F;
typedef vuSphericViewFilter<2,float> vuSphericViewFilter2F;
typedef vuSphericViewFilter<3,float> vuSphericViewFilter3F;

#endif /* __GENERAL_VU_SPHERIC_VIEW_FILTER_H__ */
