#include "vuSphericViewFilter.h"

template <int S, class T>
vuSphericViewFilter<S,T>::vuSphericViewFilter()
{
  m_NumberOfViews     = 0;
  m_Views             = NULL;
  m_Image             = NULL;
  m_Width             = 0;
  m_Height            = 0;
  ensureImage(4,4); // black image
}

template <int S, class T>
vuSphericViewFilter<S,T>::vuSphericViewFilter(const vuString& filterName)
  : vuFilter(filterName)
{
  m_NumberOfViews     = 0;
  m_Views             = NULL;
  m_Image             = NULL;
  m_Width             = 0;
  m_Height            = 0;
  ensureImage(4,4); // black image
}

template <int S, class T>
vuSphericViewFilter<S,T>::~vuSphericViewFilter()
{
  CHECKNDELETE(m_Views);
  CHECKNDELETE(m_Image);
  m_NumberOfViews = 0;
}

template <int S, class T>
void vuSphericViewFilter<S,T>::setNumberOfViews(dword count)
{
  if (m_Views == NULL || m_NumberOfViews != count) {
    CHECKNDELETE(m_Views);
    m_Views         = new vuSphericView<S,T>*[count];
    m_NumberOfViews = count;
  }
}

template <int S, class T>
dword vuSphericViewFilter<S,T>::getNumberOfViews()
{
  return m_NumberOfViews;
}

template <int S, class T>
vuSphericView<S,T>** vuSphericViewFilter<S,T>::getViews()
{
  return m_Views;
}

template <int S, class T>
vuSphericView<S,T>* vuSphericViewFilter<S,T>::getView(dword i)
{
  if (i>= m_NumberOfViews) return NULL;
  return m_Views[i];
}

template <int S, class T>
int vuSphericViewFilter<S,T>::getIndexOfView(vuSphericView<S,T> *view)
{
  for (dword i=0; i<m_NumberOfViews; i++) {
    if (view == m_Views[i]) return i;
  }
  return -1;
}

template <int S, class T>
void vuSphericViewFilter<S,T>::setView(dword idx, vuSphericView<S,T> *view)
{
  if (m_Views == NULL || idx >= m_NumberOfViews) {
    cerr << "vuSphericViewFilter.setView(): idx out of range" << endl;
    throw "vuSphericViewFilter.setView(): idx out of range";
    return;
  }
  m_Views[idx] = view;
}

template <int S, class T>
void vuSphericViewFilter<S,T>::glRender()
{
  if (m_Image)
    m_Image->glRender();
  else
    log("WARNING: vuSphericViewFilter.render(): m_Image is NULL!");
}

template <int S, class T>
void vuSphericViewFilter<S,T>::initOpenGL(void)
{
  if (m_Image)
    m_Image->initOpenGL();
  else
    log("WARNING: vuSphericViewFilter.initOpenGL(): m_Image is NULL!");
}

template <int S, class T>
void vuSphericViewFilter<S,T>::glResize(dword width, dword height)
{
  m_Width  = width;
  m_Height = height;
  if (m_Image != NULL)
    m_Image->glResize(width, height);
  else
    log("WARNING: vuSphericViewFilter.glResize(): m_Image is NULL!");
}

template <int S, class T> 
void vuSphericViewFilter<S,T>::preprocess(vuProgressHandler *handler)
{
}

template <int S, class T>
void vuSphericViewFilter<S,T>::ensureImage(dword width, dword height)
{
  if (width == 0 || height == 0) {
    if (m_NumberOfViews == 0) return;
    
    width = m_Views[0]->getWidth();
    height = m_Views[0]->getHeight();
  }
  
  if (m_Image == NULL) {
    m_Image = new vuFixelMap<S,T>(width,height);
    if (m_Width && m_Height)
      glPixelZoom((float)m_Width/width, (float)m_Height/height);
    cerr << "ensureImage... NEW " << endl;
  }
  else if (m_Image->getWidth() != width || m_Image->getHeight() != height) {
    CHECKNDELETE(m_Image);
    m_Image = new vuFixelMap<S,T>(width, height);
    if (m_Width && m_Height)
      glPixelZoom((float)m_Width/width, (float)m_Height/height);
    cerr << "ensureImage... RENEW " << endl;
  }
}

template <int S, class T>
void vuSphericViewFilter<S,T>::log(const char *msg)
{
  cerr << msg << endl;
}


template <int S, class T>
vuFixelMap<S,T> *vuSphericViewFilter<S,T>::getMap()
{
  return m_Image;
}


