/** The vuSphericView template holds all neccessary data for a spherical view.
    It consists of a FixelMap (the "image"), a some camera parameters
    (lookFrom and up vector).
*/

/*! The instance variable m_map will not be retained or "new"ed. It's just
    a pointer to another FixelMap living outside of the vuSphericView. So
    make sure not to delete the original FixelMap before you delete the
    vuSphericView.
*/


#ifndef __VU_SPHERICVIEW_H__
#define __VU_SPHERICVIEW_H__

#include <stddef.h>
#include "vuSimpleTypes.h"
#include "vuFixelMap.h"
#include "vuLinAlg/vuVector.h"

class vuSphericView_ST
{
 public:
  virtual vuVector &getLookFrom() = 0;
};

template <int SIZE, class TYPE>
class vuSphericView : public vuSphericView_ST {
 public:
  // constructor
  vuSphericView();

  // constructor
  vuSphericView(vuFixelMap<SIZE,TYPE> *map, vuVector &lookFrom, vuVector &up);

  // constructor
  vuSphericView(dword width, dword height, vuVector lookFrom=vuVector(1,0,0),
		                           vuVector up=vuVector(0,1,0));

  // destructor
  virtual ~vuSphericView();

  // copy constructor
  vuSphericView(const vuSphericView &other);

  void setLookFrom(const vuVector &lookFrom);
  vuVector &getLookFrom();

  void setUp(const vuVector &up);
  vuVector &getUp();

  vuFixelMap<SIZE,TYPE> *getMap();

  dword getWidth();
  dword getHeight();

  //!Initialize openGL
  void initOpenGL(void);
  //!OpenGl Resize callback
  void glResize(dword width, dword height);
  //! Renders the Map
  void glRender();

  // operator overloading
  vuSphericView &operator=(const vuSphericView &other);

  bool writeToFileStream(ostream *out);

  bool readFromFileStream(istream *in, dword width, dword height);

  void readFromBuffer(byte *buffer, dword width, dword height);

  void writeIntoBuffer(byte *buffer, dword width, dword height);

  static dword getSizeInByte(dword width, dword height);

protected:
  vuFixelMap<SIZE,TYPE> *m_map;
  vuVector              m_lookFrom;
  vuVector              m_up;
  bool                  m_isMapNewed;
};

template class vuSphericView<1,byte>;
template class vuSphericView<2,byte>;
template class vuSphericView<3,byte>;

template class vuSphericView<1,float>;
template class vuSphericView<2,float>;
template class vuSphericView<3,float>;


typedef vuSphericView<1,byte> vuSphericView1B;
typedef vuSphericView<2,byte> vuSphericView2B;
typedef vuSphericView<3,byte> vuSphericView3B;

typedef vuSphericView<1,float> vuSphericView1F;
typedef vuSphericView<2,float> vuSphericView2F;
typedef vuSphericView<3,float> vuSphericView3F;

#endif /* __VU_SPHERICVIEW_H__ */
