#include "vuSphericView.h"

template <int S, class T>
vuSphericView<S,T>::vuSphericView()
{
  m_map        = NULL;
  m_lookFrom   = vuVector(1,0,0);
  m_up         = vuVector(0,1,0);
  m_isMapNewed = false;
}

template <int S, class T>
vuSphericView<S,T>::vuSphericView(vuFixelMap<S,T> *map,
				  vuVector &lookFrom,
				  vuVector &up)
{
  m_map        = map;
  m_lookFrom   = lookFrom;
  m_up         = up;
  m_isMapNewed = false;
}

template <int S, class T>
vuSphericView<S,T>::vuSphericView(dword width, dword height,
				  vuVector lookFrom,
				  vuVector up)
{
  m_map        = new vuFixelMap<S,T>(width, height);
  m_lookFrom   = lookFrom;
  m_up         = up;
  m_isMapNewed = true;
}

template <int S, class T>
vuSphericView<S,T>::~vuSphericView()
{
  if (m_isMapNewed && m_map != NULL) {
    delete m_map;
    m_map = NULL;
  }
}

template <int S, class T>
vuSphericView<S,T>::vuSphericView(const vuSphericView &other)
{
  cerr << "vuSphericView(other)" << endl;
  if (!other.m_isMapNewed) {
    m_map        = other.m_map;
    m_lookFrom   = other.m_lookFrom;
    m_up         = other.m_up;
    m_isMapNewed = false;
  }
  else {
    cerr << "vuSphericView::copy constructor this case is not implmented!";
    cerr << endl;
    throw "vuSphericView::copy constructor this case is not implmented!";
  }
}

template <int S, class T>
void vuSphericView<S,T>::setLookFrom(const vuVector &lookFrom)
{
  m_lookFrom = lookFrom;
}

template <int S, class T>
vuVector &vuSphericView<S,T>::getLookFrom()
{
  return m_lookFrom;
}

template <int S, class T>
void vuSphericView<S,T>::setUp(const vuVector &up)
{
  m_up = up;
}

template <int S, class T>
vuVector &vuSphericView<S,T>::getUp()
{
  return m_up;
}


template <int S, class T>
vuFixelMap<S,T> *vuSphericView<S,T>::getMap()
{
  return m_map;
}

template <int S, class T>
dword vuSphericView<S,T>::getWidth()
{
  return (m_map == NULL) ? 0 : m_map->getWidth();
}


template <int S, class T>
dword vuSphericView<S,T>::getHeight()
{
  return (m_map == NULL) ? 0 : m_map->getHeight();
}


/* ----------------------------------------------------------------------- */
/* --- some Open Gl related things --------------------------------------- */
/* ----------------------------------------------------------------------- */

template <int S, class T>
void vuSphericView<S,T>::initOpenGL()
{
  if (m_map) m_map->initOpenGL();
}

template <int S, class T>
void vuSphericView<S,T>::glResize(dword width, dword height)
{
  if (m_map) m_map->glResize(width, height);
}

template <int S, class T>
void vuSphericView<S,T>::glRender()
{
  if (m_map) m_map->glRender();
}



template <int S, class T>
vuSphericView<S,T> &vuSphericView<S,T>::operator=(const vuSphericView &other)
{
  if (!other.m_isMapNewed) {
    m_map        = other.m_map;
    m_lookFrom   = other.m_lookFrom;
    m_up         = other.m_up;
    m_isMapNewed = false;
  }
  else {
    cerr << "vuSphericView::operator= this case is not implmented!";
    cerr << endl;
    throw "vuSphericView::operator= this case is not implmented!";
  }
  return *this;
}

template <int S, class T>
bool vuSphericView<S,T>::writeToFileStream(ostream *out)
{
  if (out) {
    m_lookFrom.normalize(); // sets 4th component to 1.0 (homogenous space)
    out->write((const char*)&m_lookFrom[0], sizeof(float));
    out->write((const char*)&m_lookFrom[1], sizeof(float));
    out->write((const char*)&m_lookFrom[2], sizeof(float));

    m_up.normalize(); // sets 4th component to 1.0 (homogenous space)
    out->write((const char*)&m_up[0], sizeof(float));
    out->write((const char*)&m_up[1], sizeof(float));
    out->write((const char*)&m_up[2], sizeof(float));

    if (out->bad()) return false;
    if (m_map != NULL)
      return m_map->writeToFileStream(out);
    else
      return false; // nothing to write, but it's still wrong
  }
  return false;
}

template <int S, class T>
bool vuSphericView<S,T>::readFromFileStream(istream *in,
					    dword width,
					    dword height)
{
  if (in) {
    in->read((char*)&m_lookFrom[0], sizeof(float));
    in->read((char*)&m_lookFrom[1], sizeof(float));
    in->read((char*)&m_lookFrom[2], sizeof(float));
    m_lookFrom[3] = 1.0f;

    in->read((char*)&m_up[0], sizeof(float));
    in->read((char*)&m_up[1], sizeof(float));
    in->read((char*)&m_up[2], sizeof(float));
    m_up[3] = 1.0f;

    if (in->bad()) return false;
    if (m_map == NULL) {
      m_map        = new vuFixelMap<S,T>;
      m_isMapNewed = true;
    }
    return m_map->readFromFileStream(in, width, height);
  }
  return false;
}

template <int S, class T>
void vuSphericView<S,T>::readFromBuffer(byte *buffer,
					dword width,
					dword height)
{
  float *fBuf = (float *)buffer;
    
  m_lookFrom[0] = *fBuf; fBuf++;
  m_lookFrom[1] = *fBuf; fBuf++;
  m_lookFrom[2] = *fBuf; fBuf++;
  m_lookFrom[3] = 1.0f;

  m_up[0] = *fBuf; fBuf++;
  m_up[1] = *fBuf; fBuf++;
  m_up[2] = *fBuf; fBuf++;
  m_up[3] = 1.0f;
 
  byte *ptr = (byte *)fBuf;

  if (m_map == NULL) {
    m_map        = new vuFixelMap<S,T>;
    m_isMapNewed = true;
  }
  m_map->assignBuffer((T*)ptr, width, height);
}

template <int S, class T>
void vuSphericView<S,T>::writeIntoBuffer(byte *buffer,
					 dword width,
					 dword height)
{
  float *fBuf = (float *)buffer;
    
  m_lookFrom.normalize(); // sets 4th component to 1.0 (homogenous space)
  *fBuf = m_lookFrom[0]; fBuf++;
  *fBuf = m_lookFrom[1]; fBuf++;
  *fBuf = m_lookFrom[2]; fBuf++;

  m_up.normalize(); // sets 4th component to 1.0 (homogenous space)
  *fBuf = m_up[0]; fBuf++;
  *fBuf = m_up[1]; fBuf++;
  *fBuf = m_up[2]; fBuf++;

  // Info: this method only writes the viewing anlges into the buffer
}

template <int S, class T>
dword vuSphericView<S,T>::getSizeInByte(dword width, dword height)
{ 
  dword result = 0;

  result += (S*sizeof(T)*width*height); // m_map
  result += (3*sizeof(float));          // m_lookFrom (3 floats)
  result += (3*sizeof(float));          // m_up       (3 floats)
  return (result);
}
