#ifndef __GENERAL_VULIGHTFIELD_VUFIXELTYPE_H__
#define __GENERAL_VULIGHTFIELD_VUFIXELTYPE_H__

#include <General/vuSimpleTypes.h>

template <class TYPE>
class vuFixelType
{
 public:
  static TYPE getMinValue();
  static TYPE getMaxValue();

  static TYPE getPosInfinity();
  static TYPE getNegInfinity();

  static bool isByte();
  static bool isFloat();
};

template class vuFixelType<float>;
template class vuFixelType<byte>;

// ------------------------------------------------------------------------

template <class INPUT_TYPE, class OUTPUT_TYPE>
class vuFixelTypeConverter
{
 public:
  static OUTPUT_TYPE getValue(INPUT_TYPE);
};

template class vuFixelTypeConverter<byte,byte>;
template class vuFixelTypeConverter<byte,float>;
template class vuFixelTypeConverter<float,byte>;
template class vuFixelTypeConverter<float,float>;

#endif /* __GENERAL_VULIGHTFIELD_VUFIXELTYPE_H__ */
