#include "vuFixelType.h"
#include <iostream.h>

template <class TYPE>
TYPE vuFixelType<TYPE>::getMinValue()
{
  cerr << "vuFixelType.getMinValue: not implemented for this type" << endl;
  throw "vuFixelType.getMinValue: not implemented for this type";
  return (TYPE)0;
}

template <class TYPE>
TYPE vuFixelType<TYPE>::getMaxValue()
{
  cerr << "vuFixelType.getMaxValue: not implemented for this type" << endl;
  throw "vuFixelType.getMaxValue: not implemented for this type";
  return (TYPE)0;
}

template <class TYPE>
TYPE vuFixelType<TYPE>::getPosInfinity()
{
  cerr << "vuFixelType.getPosInfinity: not implemented for this type" << endl;
  throw "vuFixelType.getMinValue: not implemented for this type";
  return (TYPE)0;
}

template <class TYPE>
TYPE vuFixelType<TYPE>::getNegInfinity()
{
  cerr << "vuFixelType.getNegInfinity: not implemented for this type" << endl;
  throw "vuFixelType.getNegInfinity: not implemented for this type";
  return (TYPE)0;
}

template <class TYPE>
bool vuFixelType<TYPE>::isByte()
{
  return false;
}

template <class TYPE>
bool vuFixelType<TYPE>::isFloat()
{
  return false;
}

// --------------------------------------------------------------------------
// --- float template instance ----------------------------------------------
// --------------------------------------------------------------------------

float vuFixelType<float>::getMinValue()
{
  return 0.0f;
}

float vuFixelType<float>::getMaxValue()
{
  return 1.0f;
}

float vuFixelType<float>::getPosInfinity()
{
  return 1000000000000.0f;
}

float vuFixelType<float>::getNegInfinity()
{
  return -1000000000000.0f;
}

bool vuFixelType<float>::isFloat()
{
  return true;
}

// --------------------------------------------------------------------------
// --- byte template instance ----------------------------------------------
// --------------------------------------------------------------------------

byte vuFixelType<byte>::getMinValue()
{
  return 0;
}

byte vuFixelType<byte>::getMaxValue()
{
  return 255;
}

byte vuFixelType<byte>::getPosInfinity()
{
  return 255;
}

byte vuFixelType<byte>::getNegInfinity()
{
  return 0;
}

bool vuFixelType<byte>::isByte()
{
  return true;
}

// *** vuFixelTypeConverter **************************************************

byte vuFixelTypeConverter<byte,byte>::getValue(byte value)
{
  return value;
}

// assuming return value: [0.0 .. 1.0]
float vuFixelTypeConverter<byte,float>::getValue(byte value)
{
  return ((float)value)/255.0f;
}

// assuming value = [0.0 .. 1.0]
byte vuFixelTypeConverter<float,byte>::getValue(float value)
{
  return (byte)(value * 255);
}

float vuFixelTypeConverter<float,float>::getValue(float value)
{
  return value;
}
