#include "vuFixel.h"


template <int S, class T>
vuFixel<S,T>::vuFixel()
{
  for(int i=0;i<S;++i) m_buffer[i] = (T)0;
}

template <int S, class T>
vuFixel<S,T>::vuFixel(const vuFixel<S,T>& inst)
{
  for(int i=0;i<S;++i) m_buffer[i] = inst.m_buffer[i];
}

template <int S, class T>
vuFixel<S,T>::vuFixel(const T *array)
{
  for(int i=0;i<S;++i) m_buffer[i] = array[i];
}

template <int S, class T>
vuFixel<S,T>::vuFixel(const T value)
{
  for(int i=0;i<S;++i) m_buffer[i] = value;
}

template <int S, class T>
vuFixel<S,T>::~vuFixel()
{
}

template <int S, class T>
T& vuFixel<S,T>::operator[](unsigned int index)
{
  return m_buffer[index];
}

template <int S, class T>
T vuFixel<S,T>::operator[](unsigned int index) const
{
  return m_buffer[index];
}

template <int S, class T>
T *vuFixel<S,T>::getBuffer()
{
  return m_buffer;
}

template <int S, class T>
T const *vuFixel<S,T>::getBuffer() const
{
  return m_buffer;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator=(const T* rhs)
{
  for(int i=0;i<S;++i) m_buffer[i] = rhs[i];
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator=(T* rhs)
{
  for(int i=0;i<S-1;++i) m_buffer[i] = rhs[i];
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator=(const vuFixel<S,T>& rhs)
{
  if (this != &rhs) {
    for(int i=0;i<S;++i) m_buffer[i] = rhs.m_buffer[i];
  }
  return *this;
}

template <int S, class T>
bool vuFixel<S,T>::operator==(const vuFixel<S,T>& rhs) const
{
  for(int i=0;i<S;++i)
    if(!m_buffer[i] == rhs[i]) return false;
  return true;
}

template <int S, class T>
vuFixel<S,T> vuFixel<S,T>::operator+(const vuFixel<S,T>& rhs) const
{
  vuFixel<S,T> ret;
  for(int i=0;i<S;++i)
    ret.m_buffer[i] = m_buffer[i] + rhs.m_buffer[i];
  return ret;
}

template <int S, class T>
vuFixel<S,T> vuFixel<S,T>::operator+(T a) const
{
  vuFixel<S,T> ret;
  for(int i=0;i<S-1;++i)
    ret.m_buffer[i] = m_buffer[i] + a;
  return ret;
}

template <int S, class T>
vuFixel<S,T> vuFixel<S,T>::operator-(const vuFixel<S,T>& rhs) const
{
  vuFixel<S,T> ret;
  for(int i=0;i<S;++i)
    ret.m_buffer[i] = m_buffer[i] - rhs.m_buffer[i];
  return ret;
}

template <int S, class T>
vuFixel<S,T> vuFixel<S,T>::operator*(const vuFixel<S,T>& rhs) const
{
  vuFixel<S,T> ret;
  for(int i=0;i<S;++i)
    ret.m_buffer[i] = m_buffer[i] * rhs.m_buffer[i];
  return ret;
}

template <int S, class T>
vuFixel<S,T> vuFixel<S,T>::operator/(const vuFixel<S,T>& rhs) const
{
  vuFixel<S,T> ret;
  for(int i=0;i<S;++i)
    ret.m_buffer[i] = m_buffer[i] / rhs.m_buffer[i];
  return ret;
}

template <int S, class T>
vuFixel<S,T> vuFixel<S,T>::operator*(T rhs) const 
{
  vuFixel<S,T> ret;
  for(int i=0;i<S;++i)
    ret.m_buffer[i] = m_buffer[i] * rhs;
  return ret;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator+=(const vuFixel<S,T>& rhs)
{
  for(int i=0;i<S;++i)
    m_buffer[i] += rhs.m_buffer[i];
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator-=(const vuFixel<S,T>& rhs)
{
  for(int i=0;i<S;++i)
    m_buffer[i] -= rhs.m_buffer[i];
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator*=(const vuFixel<S,T>& rhs)
{
  for(int i=0;i<S;++i)
    m_buffer[i] *= rhs.m_buffer[i];
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator/=(const vuFixel<S,T>& rhs)
{
  for(int i=0;i<S;++i)
    m_buffer[i] /= rhs.m_buffer[i];
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator*=(T rhs)
{
  for(int i=0;i<S;++i)
    m_buffer[i] *= rhs;
  return *this;
}

template <int S, class T>
vuFixel<S,T>& vuFixel<S,T>::operator/=(T rhs)
{
  for(int i=0;i<S;++i)
    m_buffer[i] /= rhs;
  return *this;
}

template <int S, class T>
word vuFixel<S,T>::size() const
{
  return S;
}

template <int S, class T>
T vuFixel<S,T>::maxComponent() const
{
  T maxc = m_buffer[0];
  for(int i=1;i<S;++i)
    if(maxc<m_buffer[i]) maxc=m_buffer[i];
  return maxc;
}

template <int S, class T>
T vuFixel<S,T>::minComponent() const
{
  T minc = m_buffer[0];
  for(int i=1;i<S;++i)
    if(minc>m_buffer[i]) minc=m_buffer[i];
  return minc;
}


/* ------------------------------------------------------------------------ */
/* --- friend functions --------------------------------------------------- */
/* ------------------------------------------------------------------------ */

#if 0
template <int S, class T> friend vuFixel<S,T>
operator*(T lhs, const vuFixel<S,T>& rhs)
{
  vuFixel<S,T> ret;
  for(int i=0;i<S;++i)
    ret.m_buffer[i] = rhs.m_buffer[i] * lhs;
  return ret;
}

template <int S, class T>
friend ostream& operator<<(ostream& os, const vuFixel<S,T>& A)
{
  const T *dat = A.m_buffer;
  os << "[" << (double)*(dat++);
  for (int i=1;i<S;i++,dat++)
    os << ", " << (double)(*dat);
  os << "]";
  return os;
}

template <int S, class T>
friend istream& operator>>(istream& is, vuFixel<S,T>& A)
{
  T *dat = A.m_buffer;
  for (int i=0; i<S;i++,dat++)
    is >> (*dat);
  return is;
}

template <int S, class T>
istream& vuFixel<S,T>::read(istream& is)
{
  T *dat = m_buffer;
  for (int i=0;i<S;i++,dat++)
    is >> (*dat);
  return is;
}

template <int S, class T>
ostream& vuFixel<S,T>::write(ostream& os) const
{
  const T *dat = m_buffer;
  for (int i=0;i<S;i++,dat++)
    os << (*dat) << " ";
  return os;
}

#endif
