#ifndef __GENERAL_VU_SphVwFlt_Lazy_H__
#define __GENERAL_VU_SphVwFlt_Lazy_H__

#include "../vuSphericViewFilter.h"

template <int SIZE, class TYPE>
class vuSphVwFlt_Lazy : public vuSphericViewFilter<SIZE,TYPE>
{
 private:
  using vuSphericViewFilter<SIZE,TYPE>::m_NumberOfViews;
  using vuSphericViewFilter<SIZE,TYPE>::m_Views;
  using vuSphericViewFilter<SIZE,TYPE>::m_Image;
  using vuSphericViewFilter<SIZE,TYPE>::log;
 public:
  vuSphVwFlt_Lazy();
  vuSphVwFlt_Lazy(const vuString& filterName);
  ~vuSphVwFlt_Lazy();

  bool needPreprocessing()     { return false; };
  bool needViewsForFiltering() { return true;  };
  void filter(vuCamera *camera);
};

template class vuSphVwFlt_Lazy<1,byte>;
template class vuSphVwFlt_Lazy<2,byte>;
template class vuSphVwFlt_Lazy<3,byte>;

template class vuSphVwFlt_Lazy<1,float>;
template class vuSphVwFlt_Lazy<2,float>;
template class vuSphVwFlt_Lazy<3,float>;

typedef vuSphVwFlt_Lazy<1,byte> vuSphVwFlt_Lazy1B;
typedef vuSphVwFlt_Lazy<2,byte> vuSphVwFlt_Lazy2B;
typedef vuSphVwFlt_Lazy<3,byte> vuSphVwFlt_Lazy3B;

typedef vuSphVwFlt_Lazy<1,float> vuSphVwFlt_Lazy1F;
typedef vuSphVwFlt_Lazy<2,float> vuSphVwFlt_Lazy2F;
typedef vuSphVwFlt_Lazy<3,float> vuSphVwFlt_Lazy3F;


#endif /* __GENERAL_VU_SphVwFlt_Lazy_H__ */
