#ifndef __GENERAL_VU_SphVwFlt_Fourier_H__
#define __GENERAL_VU_SphVwFlt_Fourier_H__

#include "../vuSphericViewFilter.h"
#include "vuFourierCluster.h"
#include "vuFourier/vuFourierFilter/vuFourierFilter.h"

template <int SIZE, class TYPE>
class vuSphVwFlt_Fourier : public vuSphericViewFilter<SIZE,TYPE>
{
 private:
  using vuSphericViewFilter<SIZE,TYPE>::m_NumberOfViews;
  using vuSphericViewFilter<SIZE,TYPE>::m_Views;
 public:
  vuSphVwFlt_Fourier(const vuString& filterName);

  bool needPreprocessing()     { return true;  };
  bool needViewsForFiltering() { return false; };
  void filter(vuCamera *camera);
  void preprocess(vuProgressHandler *handler=NULL);

  // --- additional API ----------------------------------------------------

  void setFourierFilter(vuFourierFilter *filter);
  void setSliceFilter(vuSliceFilter *filter);

  void computeUnscaledImage(vuCamera *camera, vuFixelMap<SIZE,float>* &image,
			    float &minVal, float &maxVal, word method);
  
  void computeUnscaledImage(vuCamera *camera, vuFixelMap<SIZE,float>* &image,
			    word method);

  bool isPreparedForInteractive();
  void setNoInteractiveMode();

  //! write frequency data to fileName
  bool writeFourierToFile(const char *fileName,
			  vuProgressHandler *handler = NULL);

  //! apply inverse FFT to frequency data a store it in fileName
  bool writeSpatialVolume(const char *fileName,
			  vuProgressHandler *handler = NULL);

  void prepareForInteractive(dword width, dword height);
  void addViewWithIndexToVolume(dword idx);

 private:
  vuFourierCluster<SIZE,TYPE> m_Volume;
};

template class vuSphVwFlt_Fourier<1,byte>;
template class vuSphVwFlt_Fourier<2,byte>;
template class vuSphVwFlt_Fourier<3,byte>;

template class vuSphVwFlt_Fourier<1,float>;
template class vuSphVwFlt_Fourier<2,float>;
template class vuSphVwFlt_Fourier<3,float>;

typedef vuSphVwFlt_Fourier<1,byte> vuSphVwFlt_Fourier1B;
typedef vuSphVwFlt_Fourier<2,byte> vuSphVwFlt_Fourier2B;
typedef vuSphVwFlt_Fourier<3,byte> vuSphVwFlt_Fourier3B;

typedef vuSphVwFlt_Fourier<1,float> vuSphVwFlt_Fourier1F;
typedef vuSphVwFlt_Fourier<2,float> vuSphVwFlt_Fourier2F;
typedef vuSphVwFlt_Fourier<3,float> vuSphVwFlt_Fourier3F;

#endif /* __GENERAL_VU_SphVwFlt_Fourier_H__ */
