#include "vuSphVwFlt_Fourier.h"
#include "vuFourier/vuFourierFilter/vuTorstensFourierFilter.h"

template <int S, class T>
vuSphVwFlt_Fourier<S,T>::vuSphVwFlt_Fourier(const vuString& filterName)
  : vuSphericViewFilter<S,T>(filterName)
{
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::preprocess(vuProgressHandler *handler)
{
  if (m_NumberOfViews > 0) {
    m_Volume.preprocess(m_NumberOfViews, m_Views, handler);
    ensureImage(m_Volume.getImageWidth(), m_Volume.getImageHeight());
  }
  else {
    cerr << "WARNING: vuSphVwFlt_Fourier::preprocess: no views set." << endl;
  }
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::filter(vuCamera *camera)
{
  if (m_Volume.isPreprocessed()) {
    m_Volume.setCamera(camera);
    m_Volume.computeSlice();
    // m_Volume.scaleAndBias(m_Image->getBuffer()); // ???
  }
}

// --- additional functions -------------------------------------------------

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::setFourierFilter(vuFourierFilter *filter)
{
  m_Volume.setFilter(filter);
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::setSliceFilter(vuSliceFilter *filter)
{
  m_Volume.setSliceFilter(filter);
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::computeUnscaledImage(vuCamera *camera,
						   vuFixelMap<S,float>* &image,
						   float &minVal,
						   float &maxVal,
						   word method)
{
  m_Volume.setCamera(camera);
  m_Volume.computeUnscaledImage(image, minVal, maxVal, method);
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::computeUnscaledImage(vuCamera *camera,
						   vuFixelMap<S,float>* &image,
						   word method)
{
  float minVal, maxVal;
  m_Volume.setCamera(camera);
  m_Volume.computeUnscaledImage(image, minVal, maxVal, method);
}

template <int S, class T>
bool vuSphVwFlt_Fourier<S,T>::isPreparedForInteractive()
{
  return m_Volume.isPreparedForInteractive();
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::setNoInteractiveMode()
{
  m_Volume.setNoInteractiveMode();
}

template <int S, class T>
bool vuSphVwFlt_Fourier<S,T>::writeFourierToFile(const char *fileName,
						 vuProgressHandler *handler)
{
  return m_Volume.writeFourierToFile(fileName, handler);
}

template <int S, class T>
bool vuSphVwFlt_Fourier<S,T>::writeSpatialVolume(const char *fileName,
						 vuProgressHandler *handler)
{
  return m_Volume.writeSpatialVolume(fileName, handler);
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::prepareForInteractive(dword width, dword height)
{
  m_Volume.prepareForInteractive(width, height);
}

template <int S, class T>
void vuSphVwFlt_Fourier<S,T>::addViewWithIndexToVolume(dword idx)
{
#if 0
  vuSphericView1B *view = NULL;

  cerr << "addViewWithIndex---- tralalalala" << endl;
  if (S == 1) {
    if (vuFixelType<T>::isByte()) view = (vuSphericView1B*)m_Views[idx];
  }
  else {
    // ??? ToDo: copy channels
  }

  if (view != NULL) {
    for (int i=0; i<S; i++) m_Volume.addView(view);
  }
  else {
    cerr << "WARNING: vuSphVwFlt_Fourier::addViewWithIndexToVolume(): "
	 << "case not implemented." << endl;
  }
#endif
}
