#ifndef __GENERAL_VU_SphVwFlt_Blend_H__
#define __GENERAL_VU_SphVwFlt_Blend_H__

#include "../vuSphericViewFilter.h"

template <int SIZE, class TYPE>
class vuSphVwFlt_Blend : public vuSphericViewFilter<SIZE,TYPE>
{
 private:
  using vuSphericViewFilter<SIZE,TYPE>::m_NumberOfViews;
  using vuSphericViewFilter<SIZE,TYPE>::m_Image;
  using vuSphericViewFilter<SIZE,TYPE>::m_Views;
  using vuSphericViewFilter<SIZE,TYPE>::log;
 public:
  vuSphVwFlt_Blend();
  vuSphVwFlt_Blend(const vuString& filterName);

  bool needPreprocessing()     { return false; };
  bool needViewsForFiltering() { return true;  };
  void filter(vuCamera *camera);

 protected:
  float _factor(dword idx, const vuVector &XX);
};

template class vuSphVwFlt_Blend<1,byte>;
template class vuSphVwFlt_Blend<2,byte>;
template class vuSphVwFlt_Blend<3,byte>;

template class vuSphVwFlt_Blend<1,float>;
template class vuSphVwFlt_Blend<2,float>;
template class vuSphVwFlt_Blend<3,float>;

typedef vuSphVwFlt_Blend<1,byte> vuSphVwFlt_Blend1B;
typedef vuSphVwFlt_Blend<2,byte> vuSphVwFlt_Blend2B;
typedef vuSphVwFlt_Blend<3,byte> vuSphVwFlt_Blend3B;

typedef vuSphVwFlt_Blend<1,float> vuSphVwFlt_Blend1F;
typedef vuSphVwFlt_Blend<2,float> vuSphVwFlt_Blend2F;
typedef vuSphVwFlt_Blend<3,float> vuSphVwFlt_Blend3F;


#endif /* __GENERAL_VU_SphVwFlt_Blend_H__ */
