#include "vuSphVwFlt_Blend.h"
#include <math.h>

template <int S, class T>
vuSphVwFlt_Blend<S,T>::vuSphVwFlt_Blend()
{
}

template <int S, class T>
vuSphVwFlt_Blend<S,T>::vuSphVwFlt_Blend(const vuString& filterName)
  : vuSphericViewFilter<S,T>(filterName)
{
}

template <int S, class T>
void vuSphVwFlt_Blend<S,T>::filter(vuCamera *camera)
{ 
  if (m_NumberOfViews > 0) {
    float *factors  = new float[m_NumberOfViews];
    float sum       = 0.0f;
    vuVector cameraLookAt = camera->getLookAtVector().makeUnit();
    vuVector cameraUp     = camera->getUpVector().makeUnit();
    vuVector cameraRight  = camera->getRightVector().makeUnit();

    // calculating the factors
    for (dword i=0; i<m_NumberOfViews; i++) {
      factors[i] = _factor(i, cameraLookAt);
      sum       += factors[i];
      cerr << factors[i] << ", ";
    }
    // normalize the factors
    for (dword i=0; i<m_NumberOfViews; i++) factors[i] /= sum;

    vuVector viewUp;
    float angle, dot;

    // calulate first view
    *m_Image  = *m_Views[0]->getMap();
    *m_Image *= factors[0];

    viewUp = m_Views[0]->getUp().makeUnit();
    angle  = acos(cameraUp.dot(viewUp)) * 180 / M_PI;
    dot    = cameraRight.dot(viewUp);
    if (dot >= 0) angle *= -1;
    m_Image->rotate(angle);

    // calculate rest...
    if (m_NumberOfViews > 1) {
      vuFixelMap<S,T> tmp(m_Image->getWidth(), m_Image->getHeight()); 
      
      for (dword i=1; i<m_NumberOfViews; i++) {
	viewUp = m_Views[i]->getUp().makeUnit();
	angle  = acos(cameraUp.dot(viewUp)) * 180 / M_PI;
	dot    = cameraRight.dot(viewUp);
	if ( dot >= 0) angle *= -1;

	tmp    = *m_Views[i]->getMap();
	tmp   *= factors[i];
	tmp.rotate(angle);

	*m_Image += tmp;
      }
    }
  }
  else
    log("vuSphVwFlt_Blend.filter(): m_NumberOfViews=0");
}

template <int S, class T>
float vuSphVwFlt_Blend<S,T>::_factor(dword idx, const vuVector &XX)
{
  float    result   = 1.0f;
  vuVector XXj      = m_Views[idx]->getLookFrom().makeUnit() * -1;
  vuVector XXi;

  for (dword i=0; i < m_NumberOfViews; i++) {
    if (i != idx) {
      XXi     = m_Views[i]->getLookFrom().makeUnit() * -1;
      result *= ((XX - XXi).norm() / (XXj - XXi).norm());
    }
  }
  return result;
}
