#ifndef __GENERAL_LIGHTFIELD_VU_SLICE_FILTER_H__
#define __GENERAL_LIGHTFIELD_VU_SLICE_FILTER_H__

#include "vuSimpleTypes.h"
#include "vuMisc/vuFilter.h"
#include <math.h>


typedef float (*vuSliceFilterCB)(float);

class vuSliceFilter : public vuFilter
{
 public:
  vuSliceFilter();
  vuSliceFilter(vuSliceFilterCB cb, const vuString& filterName);
  ~vuSliceFilter();

  void setWidth(dword width);
  dword getWidth();

  void setKind(byte kind);
  byte getKind();

  // 1.0 -> no filtering (100%), 0.01 -> strong filtering (1%)
  void setLowPassFactor(float lowPass);
  float getLowPassFactor();

  inline float vuSliceFilter::getWeight(float x)
  { 
    return (fabs(x) > 1.0f) ? 0.0f : m_Callback(x);
  };

  inline float vuSliceFilter::getTransformedWeight(float x) 
  {
      if (x == 0)
	return m_FilterWidth;
      else {
	float xx = (m_FilterWidth * x) / (2 * M_PI);
	return m_FilterWidth * (sin(xx)/xx);
      }
  }

  static void getFilterNames(vuString* &filterNames, dword& numOfNames);
  static vuSliceFilter *getFilter(const vuString& filterName);

 private:
  vuSliceFilterCB m_Callback;
  vuSliceFilterCB m_TransformedCallback;
  dword           m_FilterWidth;
  byte            m_FilterKind;
  float           m_LowPassFactor;
};

float vuSliceFilter_box(float x);
float vuSliceFilter_linear(float x);
float vuSliceFilter_quadratic(float x);
float vuSliceFilter_cubic(float x);
float vuSliceFilter_gaussian(float x);

#endif /* __GENERAL_LIGHTFIELD_VU_SLICE_FILTER_H__ */
