#include "vuSliceFilter.h"

#define SQRT_THREE 1.7320508

// this constructor should not be called!!!
vuSliceFilter::vuSliceFilter()
{
  m_FilterWidth   = 1;
  m_FilterKind    = 0;   // separable filter
  m_Callback      = NULL;
  m_LowPassFactor = 1.0; // no low pass filtering (100%)
}

vuSliceFilter::vuSliceFilter(vuSliceFilterCB cb, const vuString& filterName)
  : vuFilter(filterName)
{
  m_FilterWidth   = 1;
  m_FilterKind    = 0; // separable filter
  m_Callback      = cb;
  m_LowPassFactor = 1.0; // no low pass filtering (100%)
}

vuSliceFilter::~vuSliceFilter()
{
}
  
void vuSliceFilter::setWidth(dword width)
{
  m_FilterWidth = width;
}

dword vuSliceFilter::getWidth()
{
  return m_FilterWidth;
}

// 0 ... separable filters
// 1 ... spheric   filters
void vuSliceFilter::setKind(byte kind)
{
  m_FilterKind = kind;
  if (m_FilterKind > 1) m_FilterKind = 0;
}

byte vuSliceFilter::getKind()
{
  return m_FilterKind;
}

void vuSliceFilter::setLowPassFactor(float lowPass)
{
  if (lowPass >  1.0) lowPass = 1.0;
  if (lowPass <= 0.0) lowPass = 0.01;

  m_LowPassFactor = lowPass;
}

float vuSliceFilter::getLowPassFactor()
{
  return m_LowPassFactor;
}

void vuSliceFilter::getFilterNames(vuString* &names, dword& num)
{
  static const dword    count         = 5;
  static const vuString result[count] = { "box",
                                          "linear",
                                          "quadratic",
                                          "cubic",
                                          "gaussian" };
  
  names = (vuString *)result;
  num   = count;
}

vuSliceFilter *vuSliceFilter::getFilter(const vuString &filterName)
{
  if (filterName == "box")
    return new vuSliceFilter(vuSliceFilter_box, "box");
  else if (filterName == "linear")
    return new vuSliceFilter(vuSliceFilter_linear, "linear");
  else if (filterName == "quadratic")
    return new vuSliceFilter(vuSliceFilter_quadratic, "quadratic");
  else if (filterName == "cubic")
    return new vuSliceFilter(vuSliceFilter_cubic, "cubic");
  else if (filterName == "gaussian")
    return new vuSliceFilter(vuSliceFilter_gaussian, "gaussian");
  else
    return NULL;
}

/* ************************************************************************ */
/* *** filter callbacks *************************************************** */
/* ************************************************************************ */

float vuSliceFilter_box(float x)
{
  return 1.0f;
}

float vuSliceFilter_linear(float x)
{
  return 1.0f - fabs(x);
}

float vuSliceFilter_quadratic(float x)
{
  return 1.0f - x*x;
}

float vuSliceFilter_cubic(float x)
{
  return 1.0f - fabs(x*x*x);
}

float vuSliceFilter_gaussian(float x)
{
  return exp(-x*x/2);
}

/* ************************************************************************ */
/* *** filter callbacks *************************************************** */
/* ************************************************************************ */
