#ifndef _FVR_vuFourierClusterN_H_
#define _FVR_vuFourierClusterN_H_

#include "vuFourierCluster.h"
#include "General/vuMisc/vuProgressHandler.h"

template <int SIZE, class TYPE>
class vuFourierClusterN
{
 public:
    void preprocess(dword numberOfViews,
		    vuSphericView<SIZE,TYPE> **view,
		    vuProgressHandler *handler=NULL);

    void prepareForInteractive(dword width, dword height);
    void addView(vuSphericView<1,TYPE> *view);

    void setSliceFilter(vuSliceFilter *sliceFilter);
    vuSliceFilter *getSliceFilter();

    void setFilter(vuFourierFilter* filter);

    dword getImageWidth();
    dword getImageHeight();

    //! Is it preprocessed?
    bool isPreprocessed();

    //! Is it prepared for interactive reconstruction?
    bool isPreparedForInteractive();

    //! sets isPreparedForInteractive to false
    void setNoInteractiveMode();

    //! write frequency data to fileName
    bool writeFourierToFile(const char *fileName,
			    vuProgressHandler *handler = NULL);

    //! apply inverse FFT to frequency data a store it in fileName
    bool writeSpatialVolume(const char *fileName,
			    vuProgressHandler *handler = NULL);


    void setCamera(vuCamera *camera);

    void computeSlice();

    void scaleAndBias(TYPE *byte);

    void computeUnscaledImage(vuCamera *camera, vuFixelMap<SIZE,float>* &image,
			      float &minVal, float &maxVal, word method);

 private:
    void _preprocess(dword num, vuSphericView<SIZE,TYPE> **views);

 private:
    vuFourierCluster<TYPE> m_Volume[SIZE]; // one volume for each channel
};

template vuFourierClusterN<1,byte>;
template vuFourierClusterN<2,byte>;
template vuFourierClusterN<3,byte>;
template vuFourierClusterN<1,float>;
template vuFourierClusterN<2,float>;
template vuFourierClusterN<3,float>;

typedef vuFourierClusterN<1,byte>  vuFourierClusterN1B;
typedef vuFourierClusterN<2,byte>  vuFourierClusterN2B;
typedef vuFourierClusterN<3,byte>  vuFourierClusterN3B;
typedef vuFourierClusterN<1,float> vuFourierClusterN1F;
typedef vuFourierClusterN<2,float> vuFourierClusterN2F;
typedef vuFourierClusterN<3,float> vuFourierClusterN3F;

#endif
