#include "vuFourierClusterN.h"

template <int S, class T>
bool vuFourierClusterN<S,T>::isPreprocessed()
{
  return m_Volume[0].isPreprocessed();
}

template <int S, class T>
bool vuFourierClusterN<S,T>::isPreparedForInteractive()
{
  return m_Volume[0].isPreparedForInteractive();
}

template <int S, class T>
void vuFourierClusterN<S,T>::setNoInteractiveMode()
{
  for (int i=0; i<S; i++) m_Volume[i].setNoInteractiveMode();
}

template <int S, class T>
void vuFourierClusterN<S,T>::prepareForInteractive(dword width, dword height)
{
  for (int i=0; i<S; i++) m_Volume[i].prepareForInteractive(width, height);
}

template <int S, class T>
void vuFourierClusterN<S,T>::setSliceFilter(vuSliceFilter *sliceFilter)
{
  for (int i=0; i<S; i++) m_Volume[i].setSliceFilter(sliceFilter);
}

template <int S, class T>
vuSliceFilter *vuFourierClusterN<S,T>::getSliceFilter()
{
  return m_Volume[0].getSliceFilter();
}

template <int S, class T>
dword vuFourierClusterN<S,T>::getImageWidth()
{
  return m_Volume[0].getImageWidth();
}

template <int S, class T>
dword vuFourierClusterN<S,T>::getImageHeight()
{
  return m_Volume[0].getImageHeight();
}


template <int S, class T>
void vuFourierClusterN<S,T>::setFilter(vuFourierFilter* filter)
{
  for (int i=0; i<S; i++) m_Volume[i].setFilter(filter);
}

template <int S, class T>
bool vuFourierClusterN<S,T>::writeFourierToFile(const char *fileName,
						vuProgressHandler *handler)
{
  bool result = true;
  vuString myFileName;

  if (S == 1) {
    myFileName = fileName;
    if (!myFileName.hasSuffix(".fvr")) myFileName += ".fvr";
    result = m_Volume[0].writeFourierToFile(myFileName, handler);
  }
  else {
    int oldRange = 0;

    if (handler) {
      oldRange = handler->getRange();
      handler->setRange(oldRange/S);
    }

    for (int i=0; i<S; i++) {
      myFileName = fileName;
      if (myFileName.hasSuffix(".fvr")) {
	myFileName = myFileName.substr(0, myFileName.getLength()-5);
      }
      myFileName += "_";
      myFileName += i;
      myFileName += ".fvr";

      result = result && m_Volume[i].writeFourierToFile(myFileName, handler);
      if (result == false) break;
    }
    if (handler) handler->setRange(oldRange);
  }
  return result;
}

template <int S, class T>
bool vuFourierClusterN<S,T>::writeSpatialVolume(const char *fileName,
						vuProgressHandler *handler)
{
  bool result = true;
  vuString myFileName;

  if (S == 1) {
    myFileName = fileName;
    if (!myFileName.hasSuffix(".vud")) myFileName += ".vud";
    result = m_Volume[0].writeSpatialVolume(myFileName, handler);
  }
  else {
    for (int i=0; i<S; i++) {
      myFileName = fileName;
      if (myFileName.hasSuffix(".vud")) {
	myFileName = myFileName.substr(0, myFileName.getLength()-5);
      }
      myFileName += "_";
      myFileName += i;
      myFileName += ".vud";

      result = result && m_Volume[i].writeSpatialVolume(myFileName, handler);
    }
  }
  return result;
}


template <int S, class T>
void vuFourierClusterN<S,T>::setCamera(vuCamera *camera)
{
  for (int i=0; i<S; i++) m_Volume[i].setCamera(camera);
}

template <int S, class T>
void vuFourierClusterN<S,T>::computeSlice()
{
  for (int i=0; i<S; i++) m_Volume[i].computeSlice();
}

template <int S, class T>
void vuFourierClusterN<S,T>::scaleAndBias(T* data)
{
  for (int i=0; i<S; i++) m_Volume[i].scaleAndBias(data);
}

template <int S, class T>
void vuFourierClusterN<S,T>::computeUnscaledImage(vuCamera *camera,
						  vuFixelMap<S,float>* &image,
						  float &minVal, float &maxVal,
						  word method)
{
  vuFixelMap<1,float> *map = NULL;

  for (int i=0; i<S; i++) {
    if (m_Volume[i].isPreprocessed()) {
      if (S == 1) map = (vuFixelMap<1,float>*)image;

      m_Volume[i].setCamera(camera);
      m_Volume[i].computeUnscaledImage(map, minVal, maxVal, method);

      if (S > 1) {
	if (image == NULL)
	  image = new vuFixelMap<S,float>(map->getWidth(), map->getHeight());
	if (!image->hasSameDimensions(map)) {
	  CHECKNDELETE(image);
	  image = new vuFixelMap<S,float>(map->getWidth(), map->getHeight());
	}
	image->copyMapToChannel(map, i);
	CHECKNDELETE(map);
      }
    }
    else {
      // return black image
      if (image == NULL) image = new vuFixelMap<S,float>(16,16);
      image->clear(vuFixel<S,float>(0.0f));
      return;
    }
  }

  if (S == 1) image = (vuFixelMap<S,float>*)map;
}

template <int S, class T>
void vuFourierClusterN<S,T>::addView(vuSphericView<1,T> *view)
{
  // ToDo: ???
}

template <int S, class T>
void vuFourierClusterN<S,T>::preprocess(dword numOfViews, 
					vuSphericView<S,T> **views,
					vuProgressHandler *handler)
{
  if (numOfViews == 0) return;

  if (handler == NULL) return _preprocess(numOfViews, views);

  dword range     = handler->getRange();
  dword constFact = 10;
  float delta     = (float)range / (float)(S*(numOfViews+2*constFact));

  dword width  = views[0]->getWidth();
  dword height = views[0]->getHeight();

  if (m_Volume[0].getSliceFilter() != NULL) {
    vuSphericView<1,T> *view = NULL;
    vuFixelMap<1,T>    *map  = NULL;
    bool               isInterupted = false;
    float              progress     = 0.0f;

    for (int j=0; j<S; j++) {
      vuString prefix = "";
      vuString msg    = "Initialize Volume";

      if (S > 1) {
	switch (j) {
          case 0: prefix += "Red: ";   break;
          case 1: prefix += "Green: "; break;
          case 2: prefix += "Blue: ";  break;
	}
      }
      msg = prefix + msg;

      progress = delta * (numOfViews+2*constFact) * j;
      handler->update((int)progress, (const char*)msg.c_str());
      m_Volume[j].initializeVolume(width, height);
      progress+= delta*constFact;

      if (!isInterupted) {
	for (dword i=0; i<numOfViews; i++) {
	  if (S == 1)
	    view = (vuSphericView<1,T> *)views[i];
	  else {
	    views[i]->getMap()->getChannel(map, j);
	    view = new vuSphericView<1,T>(map, views[i]->getLookFrom(),
					  views[i]->getUp());
	  }
	  msg  = "add view ";
	  msg += i;
	  msg = prefix + msg;

	  progress += delta;
	  if (!handler->update((int)progress, msg.c_str())) {
	    isInterupted = true;
	    break;
	  }
	  m_Volume[j].addViewToVolume(view);
	}
      }
      msg = "Normalize Volume";
      msg = prefix + msg;
      progress+= delta*constFact;
      handler->update((int)progress, msg.c_str());
      m_Volume[j].normalizeVolume();
      m_Volume[j].wrapAndInitialize(1.0);
      m_Volume[j].m_IsPreprocessed           = true;
      m_Volume[j].m_IsPreparedForInteractive = false;
    }
    if (S > 1) {
      CHECKNDELETE(view);
      CHECKNDELETE(map);
    }
  }
  else {    
    cerr << "vuFourierClusterN::preprocess(): sliceFilter is not set!" << endl;
  }
}

template <int S, class T>
void vuFourierClusterN<S,T>::_preprocess(dword num, vuSphericView<S,T> **views)
{
  if (num == 0) return;

  dword width  = views[0]->getWidth();
  dword height = views[0]->getHeight();

  for (int i=0; i<S; i++) m_Volume[i].initializeVolume(width, height);

  if (m_Volume[0].getSliceFilter() != NULL) {
    for (dword i=0; i<num; i++) {
      cerr << "add slice " << i << ": ";
      for (int j=0; j<S; j++) {
	vuSphericView<1,T> *view = NULL;
	vuFixelMap<1,T>    *map  = NULL;

	if (S == 1)
	  view = (vuSphericView<1,T> *)views[i];
	else {
	  cerr << "+";
	  views[i]->getMap()->getChannel(map, j);
	  view = new vuSphericView<1,T>(map, views[i]->getLookFrom(),
					views[i]->getUp());
	}
	m_Volume[j].addViewToVolume(view);

	if (S > 1) {
	  CHECKNDELETE(view);
	  CHECKNDELETE(map);
	}
      }
      cerr << " done." << endl;
    }
    for (int i=0; i<S; i++) m_Volume[i].normalizeVolume();
  }
  else {    
    cerr << "vuFourierClusterN::preprocess(): sliceFilter is not set!" << endl;
  }

  for (int i=0; i<S; i++) {
    m_Volume[i].wrapAndInitialize(1.0);
    m_Volume[i].m_IsPreprocessed           = true;
    m_Volume[i].m_IsPreparedForInteractive = false;
  }
}
