#ifndef _FVR_vuFourierCluster_H_
#define _FVR_vuFourierCluster_H_

#include <vuSimpleTypes.h>
#include "vuLightfield/vuFixelMap.h"
#include "vuLightfield/vuSphericView.h"
#include "vuFourier/vuFourierVolume.h"
#include "vuSliceFilter.h"
#include "vuMisc/vuProgressHandler.h"

template <int SIZE, class TYPE>
class vuFourierCluster : public vuFourierVolume<SIZE>
{
 typedef void(vuFourierCluster<SIZE,TYPE>::* KernelCallback)(vuVector&,float*);

 private:
    using vuFourierVolume<SIZE>::m_ZSize;
    using vuFourierVolume<SIZE>::m_Volume;
    using vuFourierVolume<SIZE>::wrapAndInitialize;
    using vuFourierVolume<SIZE>::computeDimensions;
    using vuFourierVolume<SIZE>::shift2D;
    using vuFourierVolume<SIZE>::calcViewVectors;
    using vuFourierVolume<SIZE>::vcoord;
 public:
    vuFourierCluster();
    ~vuFourierCluster();

    void preprocess(dword idx, vuSphericView<SIZE,TYPE> **view,
		    vuProgressHandler *handler=NULL);

    void prepareForInteractive(dword width, dword height);
    void addView(vuSphericView<SIZE,TYPE> *view);

    void setSliceFilter(vuSliceFilter *sliceFilter);
    vuSliceFilter *getSliceFilter();

    //! Is it preprocessed?
    bool isPreprocessed();

    //! Is it prepared for interactive reconstruction?
    bool isPreparedForInteractive();

    //! sets isPreparedForInteractive to false
    void setNoInteractiveMode();

 protected:
    using vuFourierVolume<SIZE>::m_XSize;
    using vuFourierVolume<SIZE>::m_YSize;

    inline int wcoord(int x, int y, int z) const
    {
	return ((z * m_YSize + y) * m_XSize + x);
    }

    void addViewToVolume(vuSphericView<SIZE,TYPE> *view);
    void handleSlice(float *slice, dword sliceWidth, dword sliceHeight,
		     vuSphericView<SIZE,TYPE> *view);

    void normalizeVolume();
    void initializeVolume(dword width, dword height);
    void transformSlice(float *slice, dword width, dword height);
    void ensurePlan(dword width, dword height);
    void destroyPlan();
    void calcSliceDimensions(vuSphericView<SIZE,TYPE> *view,
			     dword &width,dword &height);
    
    // *** filtering ************************************************
    void doFilteringSeparable(vuVector& pos, float *value);
    void doFilteringSpheric(vuVector& pos, float *value);


    // *** weighting for interactive reconstruction case
    void weightView(vuSphericView<SIZE,TYPE> *view);
    void doWeighting(vuVector& pos, float *value);


    // *** premultiply slice ****************************************
    void premultiplySlice(vuFixelMap2F *slice);
 
 protected:
    fftwnd_plan   m_Plan;
    dword         m_PlanWidth;
    dword         m_PlanHeight;
    bool          m_IsPreprocessed;
    bool          m_IsPreparedForInteractive;
    float         *m_WeightVolume;
    vuSliceFilter *m_SliceFilter;
    float         *m_CacheVolume; // for interactive reconstruction

    // cache variables mc_ -> member cache
    float mc_HalfWidth;
    int   mc_High;
    int   mc_Low;
    bool  mc_IsWidthOdd;
};

template class vuFourierCluster<1,byte>;
template class vuFourierCluster<2,byte>;
template class vuFourierCluster<3,byte>;
template class vuFourierCluster<1,float>;
template class vuFourierCluster<2,float>;
template class vuFourierCluster<3,float>;

typedef vuFourierCluster<1,byte>  vuFourierCluster1B;
typedef vuFourierCluster<2,byte>  vuFourierCluster2B;
typedef vuFourierCluster<3,byte>  vuFourierCluster3B;
typedef vuFourierCluster<1,float> vuFourierCluster1F;
typedef vuFourierCluster<2,float> vuFourierCluster2F;
typedef vuFourierCluster<3,float> vuFourierCluster3F;

#endif
