#ifndef __VU_SPHERIC_LIGHTFIELD_FOURIER_H__
#define __VU_SPHERIC_LIGHTFIELD_FOURIER_H__

#include "vuSphericLightfieldBasicConverter.h"
#include <fftw.h>

template <int SI, class TI, int SO, class TO>
class vuSphericLightfieldFourier : public vuSphericLightfieldBasicConverter<SI,TI,SO,TO>
{
 public:

  vuSphericLightfieldFourier();

  virtual ~vuSphericLightfieldFourier();

  void _ensurePlan(dword width, dword height);  

  //!in and out are considered to have the same resolution (width*height)
  void _convert(vuSphericView<SI,TI> *in, vuSphericView<SO,TO> *out);

  protected:
    fftwnd_plan m_Plan;
    fftwnd_plan m_PlanForward;
    bool        m_PlanExists;

};


template class vuSphericLightfieldFourier<1,float,1,float>;
template class vuSphericLightfieldFourier<1,float,2,float>;
template class vuSphericLightfieldFourier<2,float,2,float>;
template class vuSphericLightfieldFourier<1,byte,2,float>;

typedef vuSphericLightfieldFourier<1,float,1,float> vuSphLFFourier1F1F;
typedef vuSphericLightfieldFourier<1,float,2,float> vuSphLFFourier1F2F;
typedef vuSphericLightfieldFourier<2,float,2,float> vuSphLFFourier2F2F;
typedef vuSphericLightfieldFourier<1,byte,2,float>  vuSphLFFourier1B2F;


class vuSphericLightfieldFourierFactory
{
 public:
  static vuBasicLightfieldConverter *getConverter(vuString &name);
};


#endif /* __VU_SPHERIC_LIGHTFIELD_FOURIER_H__ */
