#include "vuSphericLightfieldFourier.h"
#include "../vuFixelType.h"

template <int SI, class TI, int SO, class TO>
vuSphericLightfieldFourier<SI,TI,SO,TO>::vuSphericLightfieldFourier()
{
  m_PlanExists = false;
}

template <int SI, class TI, int SO, class TO>
vuSphericLightfieldFourier<SI,TI,SO,TO>::~vuSphericLightfieldFourier()
{
  if (m_PlanExists) {
    fftwnd_destroy_plan(m_Plan);
    fftwnd_destroy_plan(m_PlanForward);
    m_PlanExists = false;
  }
}

template <int SI, class TI, int SO, class TO>
void vuSphericLightfieldFourier<SI,TI,SO,TO>::_ensurePlan(dword width,
							  dword height)
{
  if (!m_PlanExists) {
    //cerr << "creating plan... ";
    m_Plan = fftw2d_create_plan(height, width, FFTW_BACKWARD, FFTW_MEASURE
				| FFTW_IN_PLACE);

    m_PlanForward = fftw2d_create_plan(height, width, FFTW_FORWARD,
				       FFTW_MEASURE | FFTW_IN_PLACE);
    m_PlanExists = true;
    //cerr << "Done." << endl;
  }
}

template <int SI, class TI, int SO, class TO>
void vuSphericLightfieldFourier<SI,TI,SO,TO>::_convert(vuSphericView<SI,TI>*in,
						      vuSphericView<SO,TO>*out)
{
  if (!_areViewsValid(in, out)) return;

  dword width  = in->getWidth();
  dword height = in->getHeight();

  _ensurePlan(width, height);

  if ((SI == 1) && (SO == 2)) {
    const TI *src = in->getMap()->getBuffer();
    TO      *dest = out->getMap()->getBuffer();

    for (dword j=0; j<height; j++) {
      for (dword i=0; i<width; i++) {
	*dest = vuFixelTypeConverter<TI,TO>::getValue(*src);
	dest++;
	*dest = (TO)0;
	dest++; src++;
      }
    }
    //cerr << "AAABB++++++++++++++++++" << endl;
    fftwnd_one(m_PlanForward, (fftw_complex*)out->getMap()->getBuffer(), NULL);      
    fftwnd_one(m_Plan, (fftw_complex*)out->getMap()->getBuffer(), NULL);

    vuFixelMap<SO,TO> *map = out->getMap();

    *map *= ((float)1/(float)(width*height));
  }
  else if ((SI == 2) && (SO == 2)) {
    const TI *src = in->getMap()->getBuffer();
    TO      *dest = out->getMap()->getBuffer();

    for (dword j=0; j<height; j++) {
      for (dword i=0; i<width; i++) {
	*(dest++) = vuFixelTypeConverter<TI,TO>::getValue(*(src++));
	*(dest++) = vuFixelTypeConverter<TI,TO>::getValue(*(src++));
      }
    }
    fftwnd_one(m_Plan, (fftw_complex*)out->getMap()->getBuffer(), NULL);
  }

}

vuBasicLightfieldConverter*
vuSphericLightfieldFourierFactory::getConverter(vuString &name)
{
  if      (name == "1F1F")
    return new vuSphLFFourier1F1F();
  else if (name == "1F2F")
    return new vuSphLFFourier1F2F();
  //    else if (name == "1F3F")
  //  return new vuSphLFFourier1F3F();
  //else if (name == "2F1F")
  //  return new vuSphLFFourier2F1F();
  else if (name == "2F2F")
    return new vuSphLFFourier2F2F();
  //else if (name == "2F3F")
  //  return new vuSphLFFourier2F3F();
  //else if (name == "3F1F")
  //  return new vuSphLFFourier3F1F();
  //else if (name == "3F2F")
  //  return new vuSphLFFourier3F2F();
  //else if (name == "3F3F")
  //  return new vuSphLFFourier3F3F();
  else if (name == "1B2F")
    return new vuSphLFFourier1B2F();
  else 
    return NULL;
}
