#ifndef __GENERAL_VU_SPHERIC_LIGHTFIELD_FILE_H__
#define __GENERAL_VU_SPHERIC_LIGHTFIELD_FILE_H__

#include "vuLightfieldFile.h"
#include "vuLightfield/vuSphericView.h"

template <int SIZE, class TYPE>
class vuSphericLightfieldFile : public vuLightfieldFile
{
 public:
  vuSphericLightfieldFile();

  //! default constructor for reading a file
  vuSphericLightfieldFile(const char *fileName);

  //! default constructor for writing a file
  vuSphericLightfieldFile(dword width, dword height, dword views,
			  const char *fileName);

  //!Destructor
  ~vuSphericLightfieldFile();

  //!Copy constructor is not implemented
  vuSphericLightfieldFile(const vuSphericLightfieldFile<SIZE,TYPE> &other);

  //!Reads the header
  bool readHeader();

  //!Writes the header
  bool writeHeader();

  //!Reads the next view from file
  bool readView(vuSphericView<SIZE,TYPE> *view);

  //!Writes the view to the file
  bool writeView(vuSphericView<SIZE,TYPE> *view);

/* ------------------------------------------------------------------------ */
/* --- accessors ---------------------------------------------------------- */
/* ------------------------------------------------------------------------ */

  dword getNumberOfViews();
  dword getWidth();
  dword getHeight();

 protected:
  //!Width of each view
  dword m_Width;
  //!Height of each view
  dword m_Height;
  //!Number of views
  dword m_NumberOfViews;

  //check data size
  bool _isDataSizeValid(dword dataSize);
};


template class vuSphericLightfieldFile<1,byte>;
template class vuSphericLightfieldFile<2,byte>;
template class vuSphericLightfieldFile<3,byte>;

template class vuSphericLightfieldFile<1,float>;
template class vuSphericLightfieldFile<2,float>;
template class vuSphericLightfieldFile<3,float>;


typedef vuSphericLightfieldFile<1,byte>  vuSphericLightfieldFile1B;
typedef vuSphericLightfieldFile<2,byte>  vuSphericLightfieldFile2B;
typedef vuSphericLightfieldFile<3,byte>  vuSphericLightfieldFile3B;

typedef vuSphericLightfieldFile<1,float> vuSphericLightfieldFile1F;
typedef vuSphericLightfieldFile<2,float> vuSphericLightfieldFile2F;
typedef vuSphericLightfieldFile<3,float> vuSphericLightfieldFile3F;

#endif /* __GENERAL_VU_SPHERIC_LIGHTFIELD_FILE_H__ */
