#ifndef __VU_SPHERIC_LIGHTFIELD_CONVERTER_H__
#define __VU_SPHERIC_LIGHTFIELD_CONVERTER_H__

#include "vuSphericLightfieldBasicConverter.h"

template <int SI, class TI, int SO, class TO>
class vuSphericLightfieldConverter : public vuSphericLightfieldBasicConverter<SI,TI,SO,TO>
{
 public:

  vuSphericLightfieldConverter();

  vuFixel<SO,TO> _fixel(vuFixel<SI,TI> in);

  //!in and out are considered to have the same resolution (width*height)
  virtual void _convert(vuSphericView<SI,TI> *in, vuSphericView<SO,TO> *out);
};


template class vuSphericLightfieldConverter<1,byte,1,byte>;
template class vuSphericLightfieldConverter<1,byte,2,byte>;
template class vuSphericLightfieldConverter<1,byte,3,byte>;
template class vuSphericLightfieldConverter<2,byte,1,byte>;
template class vuSphericLightfieldConverter<2,byte,2,byte>;
template class vuSphericLightfieldConverter<2,byte,3,byte>;
template class vuSphericLightfieldConverter<3,byte,1,byte>;
template class vuSphericLightfieldConverter<3,byte,2,byte>;
template class vuSphericLightfieldConverter<3,byte,3,byte>;

template class vuSphericLightfieldConverter<1,float,1,float>;
template class vuSphericLightfieldConverter<1,float,2,float>;
template class vuSphericLightfieldConverter<1,float,3,float>;
template class vuSphericLightfieldConverter<2,float,1,float>;
template class vuSphericLightfieldConverter<2,float,2,float>;
template class vuSphericLightfieldConverter<2,float,3,float>;
template class vuSphericLightfieldConverter<3,float,1,float>;
template class vuSphericLightfieldConverter<3,float,2,float>;
template class vuSphericLightfieldConverter<3,float,3,float>;

template class vuSphericLightfieldConverter<1,byte,1,float>;
template class vuSphericLightfieldConverter<1,byte,2,float>;
template class vuSphericLightfieldConverter<1,byte,3,float>;
template class vuSphericLightfieldConverter<2,byte,1,float>;
template class vuSphericLightfieldConverter<2,byte,2,float>;
template class vuSphericLightfieldConverter<2,byte,3,float>;
template class vuSphericLightfieldConverter<3,byte,1,float>;
template class vuSphericLightfieldConverter<3,byte,2,float>;
template class vuSphericLightfieldConverter<3,byte,3,float>;

template class vuSphericLightfieldConverter<1,float,1,byte>;
template class vuSphericLightfieldConverter<1,float,2,byte>;
template class vuSphericLightfieldConverter<1,float,3,byte>;
template class vuSphericLightfieldConverter<2,float,1,byte>;
template class vuSphericLightfieldConverter<2,float,2,byte>;
template class vuSphericLightfieldConverter<2,float,3,byte>;
template class vuSphericLightfieldConverter<3,float,1,byte>;
template class vuSphericLightfieldConverter<3,float,2,byte>;
template class vuSphericLightfieldConverter<3,float,3,byte>;


typedef vuSphericLightfieldConverter<1,byte,1,byte>   vuSphLFConverter1B1B;
typedef vuSphericLightfieldConverter<1,byte,2,byte>   vuSphLFConverter1B2B;
typedef vuSphericLightfieldConverter<1,byte,3,byte>   vuSphLFConverter1B3B;
typedef vuSphericLightfieldConverter<2,byte,1,byte>   vuSphLFConverter2B1B;
typedef vuSphericLightfieldConverter<2,byte,2,byte>   vuSphLFConverter2B2B;
typedef vuSphericLightfieldConverter<2,byte,3,byte>   vuSphLFConverter2B3B;
typedef vuSphericLightfieldConverter<3,byte,1,byte>   vuSphLFConverter3B1B;
typedef vuSphericLightfieldConverter<3,byte,2,byte>   vuSphLFConverter3B2B;
typedef vuSphericLightfieldConverter<3,byte,3,byte>   vuSphLFConverter3B3B;

typedef vuSphericLightfieldConverter<1,float,1,float> vuSphLFConverter1F1F;
typedef vuSphericLightfieldConverter<1,float,2,float> vuSphLFConverter1F2F;
typedef vuSphericLightfieldConverter<1,float,3,float> vuSphLFConverter1F3F;
typedef vuSphericLightfieldConverter<2,float,1,float> vuSphLFConverter2F1F;
typedef vuSphericLightfieldConverter<2,float,2,float> vuSphLFConverter2F2F;
typedef vuSphericLightfieldConverter<2,float,3,float> vuSphLFConverter2F3F;
typedef vuSphericLightfieldConverter<3,float,1,float> vuSphLFConverter3F1F;
typedef vuSphericLightfieldConverter<3,float,2,float> vuSphLFConverter3F2F;
typedef vuSphericLightfieldConverter<3,float,3,float> vuSphLFConverter3F3F;

typedef vuSphericLightfieldConverter<1,byte,1,float>   vuSphLFConverter1B1F;
typedef vuSphericLightfieldConverter<1,byte,2,float>   vuSphLFConverter1B2F;
typedef vuSphericLightfieldConverter<1,byte,3,float>   vuSphLFConverter1B3F;
typedef vuSphericLightfieldConverter<2,byte,1,float>   vuSphLFConverter2B1F;
typedef vuSphericLightfieldConverter<2,byte,2,float>   vuSphLFConverter2B2F;
typedef vuSphericLightfieldConverter<2,byte,3,float>   vuSphLFConverter2B3F;
typedef vuSphericLightfieldConverter<3,byte,1,float>   vuSphLFConverter3B1F;
typedef vuSphericLightfieldConverter<3,byte,2,float>   vuSphLFConverter3B2F;
typedef vuSphericLightfieldConverter<3,byte,3,float>   vuSphLFConverter3B3F;

typedef vuSphericLightfieldConverter<1,float,1,byte>   vuSphLFConverter1F1B;
typedef vuSphericLightfieldConverter<1,float,2,byte>   vuSphLFConverter1F2B;
typedef vuSphericLightfieldConverter<1,float,3,byte>   vuSphLFConverter1F3B;
typedef vuSphericLightfieldConverter<2,float,1,byte>   vuSphLFConverter2F1B;
typedef vuSphericLightfieldConverter<2,float,2,byte>   vuSphLFConverter2F2B;
typedef vuSphericLightfieldConverter<2,float,3,byte>   vuSphLFConverter2F3B;
typedef vuSphericLightfieldConverter<3,float,1,byte>   vuSphLFConverter3F1B;
typedef vuSphericLightfieldConverter<3,float,2,byte>   vuSphLFConverter3F2B;
typedef vuSphericLightfieldConverter<3,float,3,byte>   vuSphLFConverter3F3B;

class vuSphericLightfieldConverterFactory
{
 public:
  static vuBasicLightfieldConverter *getConverter(vuString &name);
};

#endif /* __VU_SPHERIC_LIGHTFIELD_CONVERTER_H__ */
