#include "vuSphericLightfieldConverter.h"
#include "../vuFixelType.h"

template <int SI, class TI, int SO, class TO>
vuSphericLightfieldConverter<SI,TI,SO,TO>::vuSphericLightfieldConverter()
{
}

template <int SI, class TI, int SO, class TO> vuFixel<SO,TO>
vuSphericLightfieldConverter<SI,TI,SO,TO>::_fixel(vuFixel<SI,TI> in)
{
  vuFixel<SO,TO> result;

  if (SI == SO) { // many to many, e.g. 3 to 3
    for (dword i=0; i<SO; i++)
      result[i] = vuFixelTypeConverter<TI,TO>::getValue(in[i]);
  }
  else if (SI == 1) { // one to many
    for (dword i=0; i<SO; i++)
      result[i] = vuFixelTypeConverter<TI,TO>::getValue(in[0]);
  }
  else if (SO == 1) { // many to one
    /* possible cases: - take first, second, ...
       - take medium, avarage, rgb->gray
    */

    // simply take first element...
    result[0] = vuFixelTypeConverter<TI,TO>::getValue(in[0]); 
  }
  else if (SI < SO) { // not-so-many to many, e.g. 2 to 3
    cerr << "not-so-many to many is not supported in the moment" << endl;
    exit(0);
  }
  else { // many to not-so-many, e.g. 3 to 2
    cerr << "many to not-so-many is not supported in the moment" << endl;
    exit(0);
  }
  return result;
}

// in and out are considered to have the same resolution (width*height)
template <int SI, class TI, int SO, class TO> void
vuSphericLightfieldConverter<SI,TI,SO,TO>::_convert(vuSphericView<SI,TI> *in, vuSphericView<SO,TO> *out)
{
  if (!_areViewsValid(in, out)) return;

  dword width  = in->getWidth();
  dword height = in->getHeight();

  vuFixelMap<SI,TI> *inMap  = in->getMap();
  vuFixelMap<SO,TO> *outMap = out->getMap();

  for (dword j=0; j<height; j++) {
    for (dword i=0; i<width; i++) {
      outMap->setFixel(i, j , _fixel(inMap->getFixel(i,j)));
    }
  }
}

vuBasicLightfieldConverter
*vuSphericLightfieldConverterFactory::getConverter(vuString &name)
{
  if      (name == "1B1B")
    return new vuSphLFConverter1B1B();
  else if (name == "1B2B")
    return new vuSphLFConverter1B2B();
  else if (name == "1B3B")
    return new vuSphLFConverter1B3B();
  else if (name == "2B1B")
    return new vuSphLFConverter2B1B();
  else if (name == "2B2B")
    return new vuSphLFConverter2B2B();
  else if (name == "2B3B")
    return new vuSphLFConverter2B3B();
  else if (name == "3B1B")
    return new vuSphLFConverter3B1B();
  else if (name == "3B2B")
    return new vuSphLFConverter3B2B();
  else if (name == "3B3B")
    return new vuSphLFConverter3B3B();

  else if (name == "1F1F")
    return new vuSphLFConverter1F1F();
  else if (name == "1F2F")
    return new vuSphLFConverter1F2F();
  else if (name == "1F3F")
    return new vuSphLFConverter1F3F();
  else if (name == "2F1F")
    return new vuSphLFConverter2F1F();
  else if (name == "2F2F")
    return new vuSphLFConverter2F2F();
  else if (name == "2F3F")
    return new vuSphLFConverter2F3F();
  else if (name == "3F1F")
    return new vuSphLFConverter3F1F();
  else if (name == "3F2F")
    return new vuSphLFConverter3F2F();
  else if (name == "3F3F")
    return new vuSphLFConverter3F3F();

  else if (name == "1F1B")
    return new vuSphLFConverter1F1B();
  else if (name == "1F2B")
    return new vuSphLFConverter1F2B();
  else if (name == "1F3B")
    return new vuSphLFConverter1F3B();
  else if (name == "2F1B")
    return new vuSphLFConverter2F1B();
  else if (name == "2F2B")
    return new vuSphLFConverter2F2B();
  else if (name == "2F3B")
    return new vuSphLFConverter2F3B();
  else if (name == "3F1B")
    return new vuSphLFConverter3F1B();
  else if (name == "3F2B")
    return new vuSphLFConverter3F2B();
  else if (name == "3F3B")
    return new vuSphLFConverter3F3B();

  else if (name == "1B1F")
    return new vuSphLFConverter1B1F();
  else if (name == "1B2F")
    return new vuSphLFConverter1B2F();
  else if (name == "1B3F")
    return new vuSphLFConverter1B3F();
  else if (name == "2B1F")
    return new vuSphLFConverter2B1F();
  else if (name == "2B2F")
    return new vuSphLFConverter2B2F();
  else if (name == "2B3F")
    return new vuSphLFConverter2B3F();
  else if (name == "3B1F")
    return new vuSphLFConverter3B1F();
  else if (name == "3B2F")
    return new vuSphLFConverter3B2F();
  else if (name == "3B3F")
    return new vuSphLFConverter3B3F();

  else 
    return NULL;
}
