#ifndef __VU_SPHERIC_LIGHTFIELD_BASIC_CONVERTER_H__
#define __VU_SPHERIC_LIGHTFIELD_BASIC_CONVERTER_H__

#include "vuSphericLightfieldFile.h"

class vuBasicLightfieldConverter
{
 public:
  virtual void convert(const char *inFile, const char *outFile,
		       bool isVerbose=true);
};

template <int SI, class TI, int SO, class TO>
class vuSphericLightfieldBasicConverter : public vuBasicLightfieldConverter
{
 public:

  //!in and out are considered to have the same resolution (width*height)
  virtual void _convert(vuSphericView<SI,TI> *in, vuSphericView<SO,TO> *out)=0;

  bool _areViewsValid(vuSphericView<SI,TI> *in, vuSphericView<SO,TO> *out);

  void convert(const char *inFile, const char *outFile, bool isVerbose=true);

  void exitWithHint(vuLightfieldFile &file);
};


template class vuSphericLightfieldBasicConverter<1,byte,1,byte>;
template class vuSphericLightfieldBasicConverter<1,byte,2,byte>;
template class vuSphericLightfieldBasicConverter<1,byte,3,byte>;
template class vuSphericLightfieldBasicConverter<2,byte,1,byte>;
template class vuSphericLightfieldBasicConverter<2,byte,2,byte>;
template class vuSphericLightfieldBasicConverter<2,byte,3,byte>;
template class vuSphericLightfieldBasicConverter<3,byte,1,byte>;
template class vuSphericLightfieldBasicConverter<3,byte,2,byte>;
template class vuSphericLightfieldBasicConverter<3,byte,3,byte>;

template class vuSphericLightfieldBasicConverter<1,float,1,float>;
template class vuSphericLightfieldBasicConverter<1,float,2,float>;
template class vuSphericLightfieldBasicConverter<1,float,3,float>;
template class vuSphericLightfieldBasicConverter<2,float,1,float>;
template class vuSphericLightfieldBasicConverter<2,float,2,float>;
template class vuSphericLightfieldBasicConverter<2,float,3,float>;
template class vuSphericLightfieldBasicConverter<3,float,1,float>;
template class vuSphericLightfieldBasicConverter<3,float,2,float>;
template class vuSphericLightfieldBasicConverter<3,float,3,float>;

template class vuSphericLightfieldBasicConverter<1,byte,1,float>;
template class vuSphericLightfieldBasicConverter<1,byte,2,float>;
template class vuSphericLightfieldBasicConverter<1,byte,3,float>;
template class vuSphericLightfieldBasicConverter<2,byte,1,float>;
template class vuSphericLightfieldBasicConverter<2,byte,2,float>;
template class vuSphericLightfieldBasicConverter<2,byte,3,float>;
template class vuSphericLightfieldBasicConverter<3,byte,1,float>;
template class vuSphericLightfieldBasicConverter<3,byte,2,float>;
template class vuSphericLightfieldBasicConverter<3,byte,3,float>;

template class vuSphericLightfieldBasicConverter<1,float,1,byte>;
template class vuSphericLightfieldBasicConverter<1,float,2,byte>;
template class vuSphericLightfieldBasicConverter<1,float,3,byte>;
template class vuSphericLightfieldBasicConverter<2,float,1,byte>;
template class vuSphericLightfieldBasicConverter<2,float,2,byte>;
template class vuSphericLightfieldBasicConverter<2,float,3,byte>;
template class vuSphericLightfieldBasicConverter<3,float,1,byte>;
template class vuSphericLightfieldBasicConverter<3,float,2,byte>;
template class vuSphericLightfieldBasicConverter<3,float,3,byte>;

#endif /* __VU_SPHERIC_LIGHTFIELD_BASIC_CONVERTER_H__ */
