#include "vuSphericLightfieldBasicConverter.h"

void vuBasicLightfieldConverter::convert(const char *inFile,
					 const char *outFile,
					 bool isVerbose) 
{
}

template <int SI, class TI, int SO, class TO>
bool vuSphericLightfieldBasicConverter<SI,TI,SO,TO>::
_areViewsValid(vuSphericView<SI,TI> *in, vuSphericView<SO,TO> *out)
{
  if (in == NULL || out == NULL)                    return false;
  if ((in->getWidth()==0) || (in->getHeight()==0))  return false;
  if (in->getWidth()  != out->getWidth())           return false;
  if (in->getHeight() != out->getHeight())          return false;

  return true;
}

template <int SI, class TI, int SO, class TO>
void vuSphericLightfieldBasicConverter<SI,TI,SO,TO>::
convert(const char *inFile, const char *outFile, bool isVerbose)
{
  vuSphericLightfieldFile<SI,TI> in(inFile);

  if (!in.open())       exitWithHint(in);
  if (!in.readHeader()) exitWithHint(in);

  dword width  = in.getWidth();
  dword height = in.getHeight();
  dword cnt    = in.getNumberOfViews();

  if (isVerbose) {
    cerr << "Input file: resolution= " << width << "x" << height << endl;
    cerr << "                 views= " << cnt   << endl;
  }

  vuSphericLightfieldFile<SO, TO> out(width, height, cnt, outFile);

  if (!out.open())        exitWithHint(out);
  if (!out.writeHeader()) exitWithHint(out);

  vuSphericView<SI,TI> *inView  = new vuSphericView<SI, TI>;
  vuSphericView<SO,TO> *outView = NULL;

  outView = new vuSphericView<SO,TO>(width, height);

  for (dword i=0; i<cnt; i++) {
    if (isVerbose) cerr << "view: " << i;

    if (!in.readView(inView))
      cerr << "Warning: Could not read view " << i << endl;
    else {
      outView->setLookFrom(inView->getLookFrom());
      outView->setUp(inView->getUp());
      _convert(inView, outView);
      if (!out.writeView(outView)) exitWithHint(out);
    }

    if (isVerbose) cerr << endl;
  }
  in.close();
  out.close();

  CHECKNDELETE(inView);
  CHECKNDELETE(outView);
}

template <int SI, class TI, int SO, class TO>
void vuSphericLightfieldBasicConverter<SI,TI,SO,TO>::
exitWithHint(vuLightfieldFile &file)
{
  cerr << "Error while processing file '" << file.getFileName();
  cerr << "': " << file.getErrorMessage() << endl;
  exit(1);
}

