#ifndef __GENERAL_VU_LIGHTFIELD_FILE_H__
#define __GENERAL_VU_LIGHTFIELD_FILE_H__

#include <fstream.h>
#include "vuString.h"

class vuLightfieldFile
{
 public:
  vuLightfieldFile();

  //! default constructor
  vuLightfieldFile(const char *fileName, bool isWritingMode);

  //!Destructor
  ~vuLightfieldFile();

  //!Returns the file name
  const char* getFileName();

  //!Returns the last error message
  const vuString getErrorMessage();

  //!Opens the file for reading or writing access
  bool open();

  //!Closes the file
  void close();

  //!Reads the header
  bool readHeader();

  //!Writes the header
  bool writeHeader();

 protected:
  bool _setErrorMessage(const char *msg);
  bool _isReadyForReading();
  bool _isReadyForWriting();

 protected:
  //!Binary = 1 (default), ASCII=2, Compressed...
  word  m_Mode;
  //!Data Size in bytes
  dword m_DataSize;
  //!Name of Data
  vuString m_DataName;
  //!Status Flag, true if in writing mode, otherwise false
  bool m_IsWritingMode;
  //!File name
  vuString m_FileName;
  //!Error Message
  vuString m_ErrorMessage;
  //!The internal file handler
  fstream *m_FileStream;
  //!Status flag, true if header is written/read, otherwise false
  bool m_IsHeaderDone;
};

#endif /* __GENERAL_VU_LIGHTFIELD_FILE_H__ */
