#include "vuLightfieldFile.h"

vuLightfieldFile::vuLightfieldFile()
{
  // this function is not supposed to call
  vuLightfieldFile::vuLightfieldFile("", false);
}

//! default constructor
vuLightfieldFile::vuLightfieldFile(const char *fileName, bool isWritingMode)
{
  m_Mode          = 1;                  // binary mode (default)
  m_DataSize      = 0;                  // unknown
  m_DataName      = vuString("data");   // default data name
  m_IsWritingMode = isWritingMode;
  m_FileName      = vuString(fileName); // file name
  m_IsHeaderDone  = false;
  m_FileStream    = NULL;
}

//!Destructor
vuLightfieldFile::~vuLightfieldFile()
{
  CHECKNDELETE(m_FileStream);
}

//!Returns the file name
const char* vuLightfieldFile::getFileName()
{
  return m_FileName.c_str();
}

//!Returns the last error message
const vuString vuLightfieldFile::getErrorMessage()
{
  return m_ErrorMessage;
}

//!Opens the file for reading or writing access
bool vuLightfieldFile::open()
{
  if (m_FileStream != NULL)
    return _setErrorMessage("FileStream is already open");
  else if (m_FileName.isEmpty())
    return _setErrorMessage("No file name specified");

  if (m_IsWritingMode) {
    m_FileStream = new fstream(m_FileName.c_str(), ios::binary | ios::out);
  }
  else {
    m_FileStream = new fstream(m_FileName.c_str(), ios::binary | ios::in);
  }

  if (!m_FileStream->is_open()) {
    m_FileStream->close();
    CHECKNDELETE(m_FileStream);
    return _setErrorMessage("Could not open file");
  }

  return true;
}

//!Closes the file
void vuLightfieldFile::close()
{
  if (m_FileStream != NULL) {
    m_FileStream->close();
  }
}

//!Reads the header
bool vuLightfieldFile::readHeader()
{
  if (!_isReadyForReading())
    return false;
  else if (m_IsHeaderDone)
    return _setErrorMessage("Header is already read");

  char str[64];
    
  m_FileStream->getline(str, 32);
  if (strcmp(str, "# vu DataFile Version 1.0") != 0)
    return _setErrorMessage("No Version 1.0 file");

  m_FileStream->getline(str, 32);
  if (strcmp(str, "Volume Data") != 0)
    return _setErrorMessage("No Volume Data file");

  m_FileStream->getline(str, 32);
  if (strcmp(str, "BINARY") == 0)
    m_Mode = 1; // binary mode
  else
    return _setErrorMessage("File is not in binary mode");

  m_FileStream->getline(str, 32);
  if (strcmp(str, "DATASET LIGHTFIELD") != 0)
    return _setErrorMessage("No Lightfield file");

  m_FileStream->getline(str, 32);
  if (strcmp(str, "UNIMODAL") != 0)
    return _setErrorMessage("No Unimodal file");

  m_IsHeaderDone = true;
  return true;
}

//!Writes the header
bool vuLightfieldFile::writeHeader()
{
  if (!_isReadyForWriting()) return false;
  if (m_DataName.isEmpty())  return _setErrorMessage("No data name set");
    
  *m_FileStream << "# vu DataFile Version 1.0" << endl;
  *m_FileStream << "Volume Data" << endl;
  if (m_Mode == 1)
    *m_FileStream << "BINARY" << endl;
  else
    return _setErrorMessage("Only binary mode is supported");
    
  *m_FileStream << "DATASET LIGHTFIELD" << endl;
  *m_FileStream << "UNIMODAL" << endl;

  m_IsHeaderDone = true;
  return true;
}

/* ------------------------------------------------------------------------ */
/* --- proctected methods ------------------------------------------------- */
/* ------------------------------------------------------------------------ */

bool vuLightfieldFile::_setErrorMessage(const char *msg)
{
  m_ErrorMessage = vuString(msg);
  return false;
}

bool vuLightfieldFile::_isReadyForReading()
{
  if (m_IsWritingMode)
    return _setErrorMessage("Is not in reading mode");
  else if (m_FileStream == NULL)
    return _setErrorMessage("FileStream is not open");
  else
    return true;
}

bool vuLightfieldFile::_isReadyForWriting()
{
  if (!m_IsWritingMode)
    return _setErrorMessage("Is not in writing mode");
  else if (m_FileStream == NULL)
    return _setErrorMessage("FileStream is not open");
  else 
    return true;
}
