#ifndef _VU_FOURIER_IO_H_
#define _VU_FOURIER_IO_H_
// set of functions to work on raw, pvp and fvr files
// need to add some checks to see if things worked and handle white space better

#include <iostream.h>
#include <fstream.h>
#include "vuSimpleTypes.h"

#define MAGIC_NUM_LEN	128

class vuFourier_IO
{
 public:
  // read XSize x YSize x ZSize integers with d_size bytes from fin to vol
  // converts to floats and assumes vol is size X, Y, Z
  static  void read_raw(ifstream& fin, float* vol, dword X, dword Y, dword Z,
			dword XSize, dword YSize, dword ZSize, dword d_size);

  // same as above, but read data members in raw
  static void read_raw_r(ifstream& fin, byte* vol, dword X, dword Y, dword Z,
			 dword XSize, dword YSize, dword ZSize, dword d_size);

  static void vuFourier_IO::read_raw_r_fast(ifstream& fin, byte* vol, dword X,
					    dword Y, dword Z, dword XSize,
					    dword YSize, dword ZSize,
					    dword d_size);

  // read pvp or fvr header; return 0 on fail, 1 if pvp, 2 if fvr
  static int read_head(ifstream& in, dword& XSize, dword& YSize, dword& ZSize,
		       dword& b_size);

  static bool write_pvp_head(ofstream& fout, dword XSize, dword YSize,
			     dword ZSize, dword b_size);

  static bool write_fvr_head(ofstream& fout, dword XSize, dword YSize,
			     dword ZSize, dword b_size);


  // apply padding, but no wrapping!!!
  static void readSpatial(byte *in, float* out, dword X, dword Y, dword Z,
			  dword XSize, dword YSize, dword ZSize);

  // wrapping the fourier volume
 static void wrapFourier(float *in, float *out,dword X, dword Y, dword Z,
			 dword XSize, dword YSize, dword ZSize);



 static float* pad(float* v, dword n);
 static byte*  pad_r(byte* v, dword n);
 static dword  readNumber(ifstream& fin);
 static void   writeNumber(ofstream& fout, dword n);
};

#endif
