#include "vuFourier_IO.h"
#include <stdio.h>
#include <string.h>

// complex pad n spaces
float* vuFourier_IO::pad(float* v, dword n)
{
  for (dword i = 0; i < n; ++i) {
    *(v++) = 0.0f;
    *(v++) = 0.0f;
  }
  return v;
}

// pad n spaces
byte* vuFourier_IO::pad_r(byte* v, dword n)
{
  for (dword i = 0; i < n; ++i) {
    *(v++) = 0;
  }
  return v;
}

dword vuFourier_IO::readNumber(ifstream& fin)
{
  dword n = 0;
  int c;

  c = fin.get();
  while((c!=' ') && (c!=10) && (c!=13))
    {
      n = n*10 + ((dword)c-'0');
      c = fin.get();
    }
  return n;
}

void vuFourier_IO::writeNumber(ofstream& fout, dword n)
{
  char number[16];

  sprintf(number, "%ld", n);
  fout.write((const char *)number, strlen(number));
  fout.put(' ');
}

/*
   in  -> input data  (spatial domain volume)
   out -> output data (fourier domain volume)

*/
void vuFourier_IO::readSpatial(byte *in, float* out,
			 dword X, dword Y, dword Z,
			 dword XSize, dword YSize, dword ZSize)
{
  byte  *i_ptr = in;
  float *v_ptr = out;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  v_ptr = pad(v_ptr, lowZ * X * Y);
  for (dword k = 0; k < ZSize; ++k) {
    v_ptr = pad(v_ptr, lowY * X);
    for (dword j = 0; j < YSize; ++j) {

      v_ptr = pad(v_ptr, lowX);
      for (dword i = 0; i < XSize; ++i) {
	*(v_ptr++) = *(i_ptr++);
	*(v_ptr++) = 0.0f;

      }
      v_ptr = pad(v_ptr, hiX);
    }
    v_ptr = pad(v_ptr, hiY * X);
  }
  v_ptr = pad(v_ptr, hiZ * X * Y);
}

void vuFourier_IO::wrapFourier(float *in, float *out,
			 dword X, dword Y, dword Z,
			 dword XSize, dword YSize, dword ZSize)
{
  float *i_ptr = in;
  float *v_ptr = out;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  v_ptr = pad(v_ptr, lowZ * X * Y);
  for (dword k = 0; k < ZSize; ++k) {
    v_ptr = pad(v_ptr, lowY * X);
    for (dword j = 0; j < YSize; ++j) {
      v_ptr = pad(v_ptr, lowX);
      for (dword i = 0; i < XSize; ++i) {
	*(v_ptr++) = *(i_ptr++);
	*(v_ptr++) = *(i_ptr++);
      }
      v_ptr = pad(v_ptr, hiX);
    }
    v_ptr = pad(v_ptr, hiY * X);
  }
  v_ptr = pad(v_ptr, hiZ * X * Y);  
}



void vuFourier_IO::read_raw(ifstream& fin, float* vol, dword X, dword Y,
			    dword Z, dword XSize, dword YSize, dword ZSize,
			    dword d_size)
{
  if (!fin.is_open()) return;

  float* v_ptr = vol;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  v_ptr = pad(v_ptr, lowZ * X * Y);
  for (dword k = 0; k < ZSize; ++k) {

    v_ptr = pad(v_ptr, lowY * X);
    for (dword j = 0; j < YSize; ++j) {

      v_ptr = pad(v_ptr, lowX);
      for (dword i = 0; i < XSize; ++i) {

	// convert d_size bytes to floating point
	float tmp = 0.0f;
	for (dword d = 0; d < d_size; ++d) {
	  tmp *= 256.0f;
	  int c = fin.get();
	  if (c < 0) cout << "huh??\n";
	  tmp += (float) c;
	}
	*(v_ptr++) = tmp;
	*(v_ptr++) = 0.0f;

      }
      v_ptr = pad(v_ptr, hiX);

    }
    v_ptr = pad(v_ptr, hiY * X);

  }
  v_ptr = pad(v_ptr, hiZ * X * Y);


}

void vuFourier_IO::read_raw_r_fast(ifstream& fin, byte* vol, dword X, dword Y,
				   dword Z, dword XSize, dword YSize,
				   dword ZSize, dword d_size)
{
  if (!fin.is_open()) return;

  byte* v_ptr = vol;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  dword bufSize = XSize * d_size;

  v_ptr = pad_r(v_ptr, lowZ * X * Y * d_size);
  for (dword k = 0; k < ZSize; ++k) {

    v_ptr = pad_r(v_ptr, lowY * X * d_size);
    for (dword j = 0; j < YSize; ++j) {

      v_ptr = pad_r(v_ptr, lowX * d_size);

      fin.read((char*)v_ptr, bufSize);
      v_ptr += bufSize;

      v_ptr = pad_r(v_ptr, hiX * d_size);

    }
    v_ptr = pad_r(v_ptr, hiY * X * d_size);

  }
  v_ptr = pad_r(v_ptr, hiZ * X * Y * d_size);
}

void vuFourier_IO::read_raw_r(ifstream& fin, byte* vol, dword X, dword Y,
			      dword Z, dword XSize, dword YSize,
			      dword ZSize, dword d_size)
{
  if (!fin.is_open()) return;

  byte* v_ptr = vol;

  dword lowX = (X - XSize) / 2;
  dword lowY = (Y - YSize) / 2;
  dword lowZ = (Z - ZSize) / 2;

  dword hiX = X - lowX - XSize;
  dword hiY = Y - lowY - YSize;
  dword hiZ = Z - lowZ - ZSize;

  v_ptr = pad_r(v_ptr, lowZ * X * Y * d_size);
  for (dword k = 0; k < ZSize; ++k) {

    v_ptr = pad_r(v_ptr, lowY * X * d_size);
    for (dword j = 0; j < YSize; ++j) {

      v_ptr = pad_r(v_ptr, lowX * d_size);
      for (dword i = 0; i < XSize; ++i) {

	for (dword d = 0; d < d_size; ++d) {
	  int c = fin.get();
	  if (c < 0) cout << "huh??\n";
	  *(v_ptr++) = (byte) c;
	}

      }
      v_ptr = pad_r(v_ptr, hiX * d_size);

    }
    v_ptr = pad_r(v_ptr, hiY * X * d_size);

  }
  v_ptr = pad_r(v_ptr, hiZ * X * Y * d_size);
}

int vuFourier_IO::read_head(ifstream& fin, dword& XSize, dword& YSize,
			    dword& ZSize, dword& b_size)
{
  if (!fin.is_open()) return 0;

  char head[MAGIC_NUM_LEN];

  int i = 0;
  int c = fin.get();
  for (; (c!=' ') && (c!=10) && (c!=13); i++) {
    head[i] = c;
    c = fin.get();
  }
  head[i] = '\0';

  int ret = 0;
  if (strcmp(head, "PVP") == 0)
    ret = 1;
  else if (strcmp(head, "FVR") == 0)
    ret = 2;
  else
    return 0;

  XSize = readNumber(fin);
  YSize = readNumber(fin);
  ZSize = readNumber(fin);
  b_size = readNumber(fin);
  return ret;
}

bool vuFourier_IO::write_pvp_head(ofstream& fout, dword XSize, dword YSize,
				  dword ZSize, dword b_size)
{
  if (!fout.is_open()) return false;
  fout.write("PVP\n", 4);
  writeNumber(fout, XSize);
  writeNumber(fout, YSize);
  writeNumber(fout, ZSize);
  writeNumber(fout, b_size);
  return true;
}

bool vuFourier_IO::write_fvr_head(ofstream& fout, dword XSize, dword YSize,
				  dword ZSize, dword b_size)
{
  if (!fout.is_open()) return false;
  fout.write("FVR\n", 4);
  writeNumber(fout, XSize);
  writeNumber(fout, YSize);
  writeNumber(fout, ZSize);
  writeNumber(fout, b_size);
  return true;
}
