#ifndef _VU_TORSTENS_FOURIER_FILTER_H_
#define _VU_TORSTENS_FOURIER_FILTER_H_

#include "vuFourierFilter.h"
#include "torstensFilters.h"

// max extent of a filter for things to work
#define VU_MAX_TFILTER_EXTENT 10

class vuTorstensFourierFilter : public vuFourierFilter
{
public:
    vuTorstensFourierFilter();
    vuTorstensFourierFilter(vuTorstensFourierFilter& l);
    vuTorstensFourierFilter(int (*filter)(float a, float t, float *coeff),
			     float a = 0.0f);
    vuTorstensFourierFilter(int (*filter)(float a, float t, float *coeff),
			     const vuString& filterName, float a = 0.0f);

    virtual ~vuTorstensFourierFilter();

    void SetFilter(int (*filter)(float a,float t,float *coeff), float a=0.0f);

    virtual dword getWidth(void);

    vuTorstensFourierFilter& operator=(vuTorstensFourierFilter& rhs);

    // filter factory methods
    static void getFilterNames(vuString* &filterNames, dword& numOfNames);
    static vuTorstensFourierFilter *getFilter(const vuString& filterName);

protected:
    virtual void MakeWeights(void);

private:
    void MakeWeightCube(float* w, float ti, float tj, float tk);

private:
    int (*m_Filter)(float a, float t, float *coeff);
    dword m_FilterWidth;
    float m_a;
};

#endif /* _VU_TORSTENS_FOURIER_FILTER_H_ */
