#include "vuTorstensFourierFilter.h"

vuTorstensFourierFilter::vuTorstensFourierFilter()
{
}

vuTorstensFourierFilter::vuTorstensFourierFilter(vuTorstensFourierFilter& l)
{
}

vuTorstensFourierFilter::vuTorstensFourierFilter(int (*filter)(float a, float t, float *coeff), float a)
{
  SetFilter(filter, a);
}

vuTorstensFourierFilter::vuTorstensFourierFilter(int (*filter)(float a, float t, float *coeff), const vuString& filterName, float a)
  : vuFourierFilter(filterName)
{
  SetFilter(filter, a);
}

vuTorstensFourierFilter::~vuTorstensFourierFilter()
{
}

vuTorstensFourierFilter& vuTorstensFourierFilter::operator=(vuTorstensFourierFilter& rhs)
{
  return *this;
}

void vuTorstensFourierFilter::SetFilter(int (*filter)(float a, float t, float *coeff), float a)
{
  float Coeff[VU_MAX_TFILTER_EXTENT];
  m_Filter = filter;
  m_FilterWidth = (dword) m_Filter(a, 0, Coeff);
  m_FilterSize = m_FilterWidth * m_FilterWidth * m_FilterWidth;
  m_a = a;

  MakeWeights();
}

dword vuTorstensFourierFilter::getWidth(void)
{
  return m_FilterWidth;
}

void vuTorstensFourierFilter::MakeWeights(void)
{
  float ti, tj, tk;
  float tstep;
  dword pos;

  m_Weights = new float[VU_FVR_FILTER_TABLE_SIZE *
			VU_FVR_FILTER_TABLE_SIZE *
			VU_FVR_FILTER_TABLE_SIZE * m_FilterSize];

  tstep = 1.0f / (float)VU_FVR_FILTER_TABLE_SIZE;

  pos = 0;
  tk = 0;
  for(dword k = 0; k < VU_FVR_FILTER_TABLE_SIZE; ++k) {
    tj = 0;
    for(dword j = 0; j < VU_FVR_FILTER_TABLE_SIZE; ++j) {
      ti = 0;
      for(dword i = 0;i < VU_FVR_FILTER_TABLE_SIZE; ++i) {
	MakeWeightCube(&m_Weights[pos], ti, tj, tk);

	pos += m_FilterSize;
	ti += tstep;
      }
      tj += tstep;
    }
    tk += tstep;
  }
}

void vuTorstensFourierFilter::MakeWeightCube(float* w, float ti, float tj, float tk)
{
  float wi[VU_MAX_TFILTER_EXTENT], wj[VU_MAX_TFILTER_EXTENT], wk[VU_MAX_TFILTER_EXTENT];

  m_Filter(m_a, ti, wi);
  m_Filter(m_a, tj, wj);
  m_Filter(m_a, tk, wk);

  dword pos = 0;
  for(dword k = 0; k < m_FilterWidth; ++k)
    for(dword j = 0; j < m_FilterWidth; ++j)
      for(dword i = 0; i < m_FilterWidth; ++i)
	w[pos++] = wi[i] * wj[j] * wk[k];
}

void vuTorstensFourierFilter::getFilterNames(vuString* &names, dword& num) 
{
  static const dword    count         = 40;
  static const vuString result[count] = { "d0_c0_1ef",
					  "d0_c0_2ef",
					  "d0_c0_3ef",
					  "d0_c0_4ef",
					  "d0_c1_1ef",
					  "d0_c1_2ef",
					  "d0_c1_3ef",
					  "d0_c1_4ef",
					  "d0_c2_1ef",
					  "d0_c2_2ef",
					  "d0_c2_3ef",
					  "d0_c2_4ef",
					  "d0_c3_1ef",
					  "d0_c3_2ef",
					  "d0_c3_3ef",
					  "d0_c3_4ef",
					  "d0_cn_1ef",
					  "d0_cn_2ef",
					  "d0_cn_3ef",
					  "d0_cn_4ef",

					  "d1_c0_1ef",
					  "d1_c0_2ef",
					  "d1_c0_3ef",
					  "d1_c0_4ef",
					  "d1_c1_1ef",
					  "d1_c1_2ef",
					  "d1_c1_3ef",
					  "d1_c1_4ef",
					  "d1_c2_1ef",
					  "d1_c2_2ef",
					  "d1_c2_3ef",
					  "d1_c2_4ef",
					  "d1_c3_1ef",
					  "d1_c3_2ef",
					  "d1_c3_3ef",
					  "d1_c3_4ef",
					  "d1_cn_1ef",
					  "d1_cn_2ef",
					  "d1_cn_3ef",
					  "d1_cn_4ef" };
  
  names = (vuString *)result;
  num   = count;
}
		    
vuTorstensFourierFilter *vuTorstensFourierFilter::getFilter(const vuString
							    &filterName)
{
  if (filterName == "d0_c0_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c0_1ef, "d0_c0_1ef");
  else if (filterName == "d0_c0_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c0_2ef, "d0_c0_2ef");
  else if (filterName == "d0_c0_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c0_3ef, "d0_c0_3ef");
  else if (filterName == "d0_c0_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c0_4ef, "d0_c0_4ef");
  else if (filterName == "d0_c1_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c1_1ef, "d0_c1_1ef");
  else if (filterName == "d0_c1_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c1_2ef, "d0_c1_2ef");
  else if (filterName == "d0_c1_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c1_3ef, "d0_c1_3ef");
  else if (filterName == "d0_c1_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c1_4ef, "d0_c1_4ef");
  else if (filterName == "d0_c2_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c2_1ef, "d0_c2_1ef");
  else if (filterName == "d0_c2_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c2_2ef, "d0_c2_2ef");
  else if (filterName == "d0_c2_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c2_3ef, "d0_c2_3ef");
  else if (filterName == "d0_c2_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c2_4ef, "d0_c2_4ef");
  else if (filterName == "d0_c3_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c3_1ef, "d0_c3_1ef");
  else if (filterName == "d0_c3_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c3_2ef, "d0_c3_2ef");
  else if (filterName == "d0_c3_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c3_3ef, "d0_c3_3ef");
  else if (filterName == "d0_c3_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_c3_4ef, "d0_c3_4ef");
  else if (filterName == "d0_cn_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_cn_1ef, "d0_cn_1ef");
  else if (filterName == "d0_cn_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_cn_2ef, "d0_cn_2ef");
  else if (filterName == "d0_cn_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_cn_3ef, "d0_cn_3ef");
  else if (filterName == "d0_cn_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d0_cn_4ef, "d0_cn_4ef");

  else if (filterName == "d1_c0_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c0_1ef, "d1_c0_1ef");
  else if (filterName == "d1_c0_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c0_2ef, "d1_c0_2ef");
  else if (filterName == "d1_c0_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c0_3ef, "d1_c0_3ef");
  else if (filterName == "d1_c0_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c0_4ef, "d1_c0_4ef");
  else if (filterName == "d1_c1_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c1_1ef, "d1_c1_1ef");
  else if (filterName == "d1_c1_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c1_2ef, "d1_c1_2ef");
  else if (filterName == "d1_c1_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c1_3ef, "d1_c1_3ef");
  else if (filterName == "d1_c1_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c1_4ef, "d1_c1_4ef");
  else if (filterName == "d1_c2_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c2_1ef, "d1_c2_1ef");
  else if (filterName == "d1_c2_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c2_2ef, "d1_c2_2ef");
  else if (filterName == "d1_c2_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c2_3ef, "d1_c2_3ef");
  else if (filterName == "d1_c2_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c2_4ef, "d1_c2_4ef");
  else if (filterName == "d1_c3_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c3_1ef, "d1_c3_1ef");
  else if (filterName == "d1_c3_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c3_2ef, "d1_c3_2ef");
  else if (filterName == "d1_c3_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c3_3ef, "d1_c3_3ef");
  else if (filterName == "d1_c3_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_c3_4ef, "d1_c3_4ef");
  else if (filterName == "d1_cn_1ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_cn_1ef, "d1_cn_1ef");
  else if (filterName == "d1_cn_2ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_cn_2ef, "d1_cn_2ef");
  else if (filterName == "d1_cn_3ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_cn_3ef, "d1_cn_3ef");
  else if (filterName == "d1_cn_4ef")
    return new vuTorstensFourierFilter(vuTorsten_d1_cn_4ef, "d1_cn_4ef");
  else
    return NULL;
}

