#ifndef _VU_FVR_FILTER_H_
#define _VU_FVR_FILTER_H_

#include "vuLinAlg/vuVector.h"
#include "vuSimpleTypes.h"
#include "vuMisc/vuFilter.h"

#define VU_FVR_FILTER_TABLE_SIZE  20
#define VU_FVR_FILTER_TABLE_MAX   19

class vuFourierFilter : public vuFilter
{
public:
	inline vuFourierFilter();
	inline vuFourierFilter(const vuString& filterName);
	inline vuFourierFilter(vuFourierFilter& f);
	virtual ~vuFourierFilter();

	inline float* getWeights(vuVector& t);
	virtual dword getWidth(void) = 0;

	inline vuFourierFilter& operator=(vuFourierFilter& rhs);

protected:
	float* m_Weights;   // A table of weights
	dword m_FilterSize;
};

inline vuFourierFilter::vuFourierFilter() : m_Weights(0)
{
}

inline vuFourierFilter::vuFourierFilter(const vuString& filterName)
  : vuFilter(filterName), m_Weights(0)
{
}

inline vuFourierFilter::vuFourierFilter(vuFourierFilter& f)
{
}

inline vuFourierFilter::~vuFourierFilter()
{
	if (m_Weights)
		delete [] m_Weights;
}

inline vuFourierFilter& vuFourierFilter::operator=(vuFourierFilter& rhs)
{
	return *this;
}

inline float* vuFourierFilter::getWeights(vuVector& t)
{
	int i = (int)((t[0] * VU_FVR_FILTER_TABLE_MAX) + 0.5);
	int j = (int)((t[1] * VU_FVR_FILTER_TABLE_MAX) + 0.5);
	int k = (int)((t[2] * VU_FVR_FILTER_TABLE_MAX) + 0.5);
	return &m_Weights[((k * VU_FVR_FILTER_TABLE_SIZE + j) * 
			   VU_FVR_FILTER_TABLE_SIZE + i) * m_FilterSize];
};


#endif
