#ifndef _VUVHIMAGE_H_
#define _VUVHIMAGE_H_

#include "vuString.h"
#include "vuSimpleTypes.h"

#define VH_MAGIC	(dword)(0x494d4746)

/** Class to manage import of fre.Z images as used in the visible human project.
 */
class vuVHImage {

 public:
    /** Constructor */
    vuVHImage();
    /** Constructor. Calls loadSlice(). */
    vuVHImage(const vuString& filename);
    /** destructor */
    virtual ~vuVHImage();

    /** Load */
    bool loadSlice(const vuString& filename);
    /* Write one slice in fre.Z format. Not implemented! *
       bool saveSlice(const vuString& filename); */
    /** Indicate that the load procedure was successful. */
    bool magicMatch() { return magic == VH_MAGIC;}

    /** Returns width (maxX) of the image. */
    dword getWidth() {return width; }
    /** Returns height (maxY) of the image. */
    dword getHeight() {return height; }
    /** Returns number of bits per sample. 
     Should be 16. */
    dword getDepth() {return depth; }
    /** Returns text table of the image. */
    const char* getTextTable() {return txtTable; }
    /** Returns a pointer to the data. 
	Two byte per pixel. So overall size is width*height*2. Order is 
	swizzled from original file to little endian (lower byte at lower 
	address). Maybe we should distinguish systems with big endian as 
        native format (SGI?) and leave it like this. That would allow that 
        always a word[] array could be mapped easily. By now we don't have 
	such a switch. */
    const byte* getData() {return data; }

 protected:
    /** Magic key.
	Should be VH_MAGIC (0x494d4746) */
    dword magic;	
    /** offset of the raw data in the file */
    dword offset;
    /** width of the image */
    dword width;
    /** height of the image */
    dword height;
    /** number of bits per sample */
    dword depth;
    /** compression type
	1 means no compression --> raw data */
    dword compressType;
    //!See the visible human project for details on this entry.
    dword defaultWindowWidth;
    //!See the visible human project for details on this entry.
    dword defaultLevelVal;
    //!See the visible human project for details on this entry.
    dword defaultBGShade;
    //!See the visible human project for details on this entry.
    dword overflowPixVal;
    //!See the visible human project for details on this entry.
    dword underflowPixVal;
    //!See the visible human project for details on this entry.
    dword blankLineTop;
    //!See the visible human project for details on this entry.
    dword blankLineBot;
    //!See the visible human project for details on this entry.
    word hdrVersion;
    //!See the visible human project for details on this entry.
    word checksum;

    //! Short info text in file
    char *txtTable;
    /** This is the raw data of the image. 
	Two byte per pixel. So overall size is width*height*2. Order is 
	swizzled from original file to little endian (lower byte at lower 
	address). */
    byte *data;
};

#endif
