#include <stdlib.h>
#include <fstream.h>
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include "vuVHImage.h"


vuVHImage::vuVHImage() 
{
    magic = 0;
    txtTable = NULL;
    data = NULL;
}

vuVHImage::vuVHImage(const vuString& filename)
{
    magic = (dword)0;
    txtTable = NULL;
    data = NULL;
    loadSlice(filename);
}

vuVHImage::~vuVHImage()
{
    if(txtTable) {
	delete txtTable;
	txtTable = NULL;
    }
    if(data) {
	delete data;
	data = NULL;
    }
}

bool vuVHImage::loadSlice(const vuString& filename)
{
    bool ret = true;
    dword len = filename.getLength();
    if(!len) return false;

    bool uncompress = false;
    ifstream fs;
    vuString tmpfn;
    if(filename.substr(len-2,len).compare(".Z") == 0)
    {
#ifdef WIN32
	return false;
#else
	uncompress = true;
	tmpfn = vuString("/tmp/vutmp") + 
	    vuString(getpgrp()) + vuString(".tmp");
	vuString commandstr = vuString("uncompress -c ") + filename +
	    " > " + tmpfn;
	system(commandstr);
	fs.open(tmpfn);
#endif
    } else fs.open(filename);
    try {
    if(fs.good()) {
	char head[156];
	fs.read(head,156);
	int p = 0;
	magic = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	if(magic != VH_MAGIC) throw;
	offset = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	width = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	height = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	depth = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	compressType = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	defaultWindowWidth = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	defaultLevelVal = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	defaultBGShade = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	overflowPixVal = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	underflowPixVal = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	blankLineTop = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	blankLineBot = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	hdrVersion = swizzle(*(word*)(head + p)); p+=sizeof(word);
	checksum = swizzle(*(word*)(head + p)); p+=sizeof(word);
	p+=sizeof(dword);
	dword txtlen = swizzle(*(dword*)(head + p)); p+=sizeof(dword);
	if(txtTable)
	    delete txtTable;
	if(txtlen) 
	{
	    txtTable = new char[txtlen+1];
	    memset(txtTable,0,txtlen+1);
	    fs.read(txtTable, txtlen);
	} else txtTable = NULL;
	
	if(data)
	    delete data;
	data = new byte[width*height*2];
	fs.seekg(offset, ios::beg);
	fs.read((char*)data, (int)(width*height*2)); // ms: cast for gcc 3.0.4
	int i;
	word *wdat = (word*)data;
	for(i=width*height; i>0; i--, wdat++)
	{
	    *wdat = swizzle(*wdat);
	}
// 	int nr = fs.
// 	cout << " numread = " << nr << endl;
// 	if(!nr == width*height*2)
// 	    {
// 		cout << " reading data failed." << endl;
// 		return false;
// 	    }
    } else throw;
    } catch (...) {
	ret = false;
    }

    if(uncompress) {
	fs.close();
	vuString commandstr = "rm -f " + tmpfn;
	system(commandstr);
    }
    
    return ret;
}

