/*	Modified April 2002
	Modified by Christopher Steinbach

	Modified to remove the ios::nocreate flag in the
	SGI-IRIX compile because it doesn't seem to be
	available for the SGIs
*/

#ifndef _vuPARSER_H_
#define _vuPARSER_H_

#include "vuSimpleTypes.h"
#include "vuString.h"
#include "vuDVector.h"
#include <fstream.h>

/** This string list type originally belongs in the vuGuiParser class.
    If we don't make up functions that use this list, we can put it back there.
    Otherwise a number list (of doubles) would also be nice...
*/
typedef vuDVector<vuString> StringList;

/** Provides basic parsing functionality.
    The functions of this class have been extracted from the original vuGuiParser to build
    a general parser base class. This can now be used to derive own parsers for arbitrary use.

 \todo
    Add some usefull functionalities to vuParser.
    readstring, readnumber (also list of numbers should be handled, only written for
    doubles because they can be converted), ...

 \todo
    Find some way to add the ios::nocreate flag or some equivalent to this code
    so that we have similar behaviour in IRIX as we do Linux or Windows.
*/
class vuParser
{
 public:
 	/** default constructor,

	   initializes everything to be 0 */
    vuParser();
    	/** destructor

	frees the memory used by the buffer
	*/
    virtual ~vuParser();

    /**Parses the given gui script file, and generates the corresponding class.
       This function is virtual a reimplementation should start with readBuffer() and
       FixBuffer() and then continue evaluating the buffer using the provided functions.
       (which are not yet written <- todo)
     */
    virtual void Parse(const char* filename) throw (const char *) {};

 protected:
    //!reads the input file into m_Buffer for processing.
    void readBuffer(const char* filename);
    //!Fixes the input buffer by separating the defined tokens.
    void FixBuffer();

    //! Try to read a string from the buffer and eats it if it's there.
    bool readString(const char* s);
    //! Try to read a string prefixed by "prefix" from the buffer and eats it if it's there.
    /** Try to read a string prefixed by "prefix" from the buffer and eats it if it's there.
        \param s buffer to copy the read string to */
    bool readString(const char* prefix, char* s);
    //! Try to read a number prefixed by "prefix" from the buffer and eats it if it's there.
    /** Try to read a number prefixed by "prefix" from the buffer and eats it if it's there.
    \param t float to copy the read number to */
    bool readNumber(const char* prefix, float& t);

    //!Checks the buffer for the token, returning true and eating it up if it's there.
    bool readToken(char token, bool eat = true);
    //!Returns true if the input stream is finished.
    bool finished();

    //!A copy of the input file contents, with separated tokens.
    char *m_Buffer;
    //!The total length of the buffer.
    dword m_Len;
    //!The reading position within the buffer.
    dword m_Pos;

};


#endif
