#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "vuParser.h"

//----------------------------------------------------------------------------
//------------------------- vuParser() ------------------------------------
//----------------------------------------------------------------------------

vuParser::vuParser()
{
    m_Buffer = 0;
    m_Pos    = 0;
    m_Len    = 0;
}

//----------------------------------------------------------------------------
//------------------------- ~vuParser() -----------------------------------
//----------------------------------------------------------------------------

vuParser::~vuParser()
{
    if (m_Buffer) delete [] m_Buffer;
}

//----------------------------------------------------------------------------
//------------------------- protected: readBuffer() ----------------------------
//----------------------------------------------------------------------------

void vuParser::readBuffer(const char* filename)
{
    ifstream ifp;
    int len;

#ifdef IS_NOCREATE_NEEDED
    ifp.open(filename, ios::in|ios::binary|ios::nocreate);
#else
	// The nocreate is not available on the IRIX boxes that we were compiling
	// this code on, so we had to remove this part from
    ifp.open(filename, ios::in|ios::binary);
#endif
    if (!ifp.is_open()) throw ("Could not open the input file.");

    //Find the length of the file.
    ifp.seekg(0, ios::end);
    len = ifp.tellg();
    ifp.seekg(0, ios::beg);

    if (m_Buffer)
        delete [] m_Buffer;
    m_Buffer = new char[len+1];
    ifp.read(m_Buffer, len);
    m_Buffer[len] = 0;
    ifp.close();

    m_Pos = 0;
}

//----------------------------------------------------------------------------
//------------------------- protected: fixBuffer() -----------------------------
//----------------------------------------------------------------------------

void vuParser::FixBuffer(void)
{
    dword i;
    dword j;
    dword len;
    char* tmp;

    i   = 0;
    len = 1;
    tmp = m_Buffer;
    while(tmp[i] != 0)
    {
        if ((tmp[i]=='{') || (tmp[i]=='}') ||
            (tmp[i]=='(') || (tmp[i]==')') ||
            (tmp[i]=='[') || (tmp[i]==']') ||
            (tmp[i]==',') || (tmp[i]==';'))
            len += 3;
        else
            ++len;
        ++i;
    }

    m_Buffer = new char[len];
    m_Len = len;

    i = 0;
    j = 0;
    while(tmp[i] != 0)
    {
        if ((tmp[i]=='{') || (tmp[i]=='}') ||
            (tmp[i]=='(') || (tmp[i]==')') ||
            (tmp[i]=='[') || (tmp[i]==']') ||
            (tmp[i]==',') || (tmp[i]==';'))
        {
            m_Buffer[j++] = ' ';
            m_Buffer[j++] = tmp[i];
            m_Buffer[j++] = ' ';
        }
		else
            m_Buffer[j++] = tmp[i];
        ++i;
    }

    delete [] tmp;
}

//----------------------------------------------------------------------------
//------------------------- protected: readToken() -----------------------------
//----------------------------------------------------------------------------

bool vuParser::readToken(char token, bool eat)
{
    int len = 0;
    vuString stoken = token;
    stoken += " %n";
    sscanf(&m_Buffer[m_Pos],stoken,&len);
    if (eat) m_Pos += len;
    return (len > 0);
}

//----------------------------------------------------------------------------
//------------------------- protected: finished() ------------------------------
//----------------------------------------------------------------------------

bool vuParser::finished()
{
    return (m_Pos>=m_Len);
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Try to read the static text given by "s" from the buffer
bool vuParser::readString(const char* s)
{
    char str[1024];
    int ret, len=0;
    strcpy(str, s);
    strcat(str, "%n");
    ret = sscanf(&m_Buffer[m_Pos], str, &len);
    if ((ret!=EOF) && (len!=0))
    {
        m_Pos += len;
        return true;
    }
    return false;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Try to read a string prefixed by "prefix" from the buffer
bool vuParser::readString(const char* prefix, char* s)
{
    char str[1024];
    int i=0;
    strcpy(str, prefix);
    strcat(str, " \"");
    if (readString(str))
    {
        while((m_Buffer[m_Pos]!='"') && m_Buffer[m_Pos])
            s[i++] = m_Buffer[m_Pos++];
        s[i] = 0;
        if (m_Buffer[m_Pos]=='"')
        {
            ++m_Pos;
            return true;
        }
    }
    return false;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Try to read a number prefixed by "prefix" from the buffer
bool vuParser::readNumber(const char* prefix, float& t)
{
    char str[1024];
    int ret, len=0;
    strcpy(str, prefix);
    strcat(str, " %f%n");
    ret = sscanf(&m_Buffer[m_Pos], str, (float*)&t, &len);
    if ((ret == 1) && (len!=0))
    {
        m_Pos += len;
        return true;
    }
    return false;
}
