#include "vuPPMReader.h"

vuPPM::vuPPM ()

{
	fp = NULL;
	m_buf = NULL;
	m_buf_size = 0;
}

vuPPM::~vuPPM ()

{
	if (m_buf != NULL)
		delete [] m_buf;
}

bool vuPPM::SaveCompressedImage (char* fname, vuImage &img)

{
	img.get_extents (m_x, m_y);

	m_z = CompressToBuffer (img);

	fp = fopen (fname, "w");

	WriteCompressedHeader (img);
	
	return true;
}

bool vuPPM::WriteCompressedHeader (vuImage &img)

{
	fputs ("C1 ", fp);

	char tstring [6];
	char tstring2 [6];

	gcvt (m_x, 4, tstring);

	int i = 0;
	int j = 0;

	while (i < (int (4 - strlen (tstring))))

	{
		tstring2 [j] = '0';
		i++;
		j++;
	}

	strcpy (&(tstring2 [j]), tstring);

	fputs (tstring2, fp);
	fputc (' ', fp);

	gcvt (m_y, 4, tstring);

	i = 0;
	j = 0;

	while (i < (int (4 - strlen (tstring))))

	{
		tstring2 [j] = '0';
		i++;
		j++;
	}

	strcpy (&(tstring2 [j]), tstring);

	fputs (tstring2, fp);
	fputc (' ', fp);

	int t1 = m_z;

	unsigned char tstr [5];

	tstr [4] = '\0';

	tstr [3] = t1 % 256;
	t1 /= 256;

	tstr [2] = t1 % 256;
	t1 /= 256;

	tstr [1] = t1 % 256;
	t1 /= 256;

	tstr [0] = t1 % 256;
	t1 /= 256;

	fputc (tstr [0], fp);
	fputc (tstr [1], fp);
	fputc (tstr [2], fp);
	fputc (tstr [3], fp);
	
	return true;
}

int vuPPM::CompressToBuffer (vuImage &img)

{
	if (m_x * m_y * 3 > m_buf_size)

	{
		delete [] m_buf;

		m_buf = new unsigned char [m_x * m_y * 3];

		m_buf_size = m_x * m_y * 3;
	}

	m_z = 0;

	int counter = 0;
	int m_buf_pos = 0;

	char *rgb = (char *) (img.get_rgb ());

	while (counter < m_x * m_y * 3)

	{
		int runlength = 0;

		if ((rgb [counter] == rgb [counter + 3]) && (rgb [counter + 1] == rgb [counter + 4]) && (rgb [counter + 2] == rgb [counter + 5]))

		{
			while ((runlength < 256) && (rgb [counter] == rgb [counter + 3]) && (rgb [counter + 1] == rgb [counter + 4]) && (rgb [counter + 2] == rgb [counter + 5]))

			{
				counter += 3;

				runlength++;
			}

			m_buf [m_buf_pos++] = 0;
			m_buf [m_buf_pos++] = runlength;

			m_buf [m_buf_pos++] = rgb [counter];
			m_buf [m_buf_pos++] = rgb [counter + 1];
			m_buf [m_buf_pos++] = rgb [counter + 2];
		}

		else

		{
			if (rgb [counter] == 0)
				m_buf [m_buf_pos++] = 1;
			else
				m_buf [m_buf_pos++] = rgb [counter];

			m_buf [m_buf_pos++] = rgb [counter + 1];
			m_buf [m_buf_pos++] = rgb [counter + 2];
		}

		counter += 3;
	}

	return m_buf_pos;
}

bool vuPPM::SaveImage (char* fname, vuImage &img)

{	// the commented code will read any valid ppm header,
	// the uncommented code is faster, and will read those saved
	// by this class
/*	fp = fopen (fname, "w");

	if (fp == NULL)
		return false;

	char tnum [20];

	fputs ("P6\n", fp);

	img.get_extents (m_x, m_y);

	gcvt (double (m_x), 16, tnum);
	strcat (tnum, "\n");

	fputs (tnum, fp);

	gcvt (double (m_y), 16, tnum);
	strcat (tnum, "\n");

	fputs (tnum, fp);

	gcvt (255.0, 16, tnum);
	strcat (tnum, "\n");

	fputs (tnum, fp); */

	img.get_extents (m_x, m_y);

	fp = fopen (fname, "w");

	WriteHeader (img);

	unsigned char* tchar = (unsigned char*) (img.get_rgb ());

//	fwrite (tchar, 1, 3 * m_x * m_y, fp);

	for (int i = 0; i < 3 * m_x * m_y; i++)
		fputc (int (tchar [i]), fp);

	fclose (fp);

	return true;
}

const int c_64k_ = 16 * 16 * 16 * 16;

#include <errno.h>

bool vuPPM::ReadCompressedImage (char* fname, vuImage &img, int readtype)

{
	if (m_buf_size < m_z)

	{
		if (m_buf)
			delete [] m_buf;

		m_buf = new unsigned char [m_z];
	}

	int x,y;

	img.get_extents (x, y);

	if ((x != m_x) || (y != m_y))
		if (!img.init (m_x, m_y))

		{
			cout << "couldn't allocate the memory needed" << endl;

			return false;
		}

	char* rgb = (char*) (img.get_rgb ());

	int ctrl = m_z;

//	read (&(rgb [counter]), 1, ctrl, fp);

	int j = 0;
	int runlength;

	int r, g, b;

	int i = 0;

	while (int (counter + c_64k_) < ctrl)

	{
//		fread_unlocked (&(rgb [counter]), 1, c_64k_, fp);
		fread (&(m_buf [counter]), 1, c_64k_, fp);

		while (i < int (counter + c_64k_ - 6))

		{
			if (m_buf [i] == 0)

			{
				runlength = m_buf [++i];

				r = m_buf [++i];
				g = m_buf [++i];
				b = m_buf [i];

				while (runlength > 0)

				{
					rgb [j++] = r;
					rgb [j++] = g;
					rgb [j++] = b;

					runlength--;
				}
			}

			else

			{
				rgb [j++] = m_buf [i++];
				rgb [j++] = m_buf [i++];
				rgb [j++] = m_buf [i];
			}

			i++;
		}

		counter += c_64k_;
	}

	fread (&(m_buf [counter]), 1, ctrl - counter, fp);

	while (i < ctrl)

	{
		if (m_buf [i] == 0)

		{
			runlength = m_buf [++i];

			r = m_buf [++i];
			g = m_buf [++i];
			b = m_buf [i];

			while (runlength > 0)

			{
				rgb [j++] = r;
				rgb [j++] = g;
				rgb [j++] = b;

				runlength--;
			}
		}

		else

		{
			rgb [j++] = m_buf [i++];
			rgb [j++] = m_buf [i++];
			rgb [j++] = m_buf [i];
		}

		i++;
	}

	fclose (fp);

	return true;
}

bool vuPPM::ReadImage (char* fname, vuImage &img, int readtype)

{
	fp = fopen (fname, "r");

	if (fp == NULL)

	{
		cout << "couldn't open: " << fname << endl;
		cout << strerror (errno) << endl;
		return false;
	}

	int readval = ReadHeader (img, readtype);

	if (!readval)

	{
		cout << "couldn't read the header for; " << fname << endl;
		return false;
	}

	if (readval == 2)
		return ReadCompressedImage (fname, img, readtype);

//	char rgb [c_64k_];
	char* rgb;

	int counter = 0;

	int x,y;

	img.get_extents (x, y);

	if ((x != m_x) || (y != m_y))
		if (!img.init (m_x, m_y))

		{
			cout << "couldn't allocate the memory needed" << endl;

			return false;
		}

	rgb = (char*) (img.get_rgb ());

	int ctrl = 3 * m_x * m_y;

//	read (&(rgb [counter]), 1, ctrl, fp);


	while (counter + c_64k_ < ctrl)

	{
//		fread_unlocked (&(rgb [counter]), 1, c_64k_, fp);
		fread (&(rgb [counter]), 1, c_64k_, fp);

		counter += c_64k_;
	}

	fread (&(rgb [counter]), 1, ctrl - counter, fp);

	fclose (fp);

//	cout << "read took: " << twatch.Time () << endl;

//	char rgb [3 * m_x * m_y + 2];

		// over 60 ms faster to use this than
		// for do fread (3 bytes)

/*	img.init (m_x, m_y);

	cout << "s1" << endl;

	fread ((void*) (img.get_rgb ()), 1, 3 * m_x * m_y, fp);

	cout << "s2" << endl;

	fclose (fp);*/

	return true;
}

bool vuPPM::ReadImageFromBuffer (char* buf, vuImage &img, int readtype)

{
	if (!ReadHeader (img, buf, readtype))

	{
		cout << "couldn't read the header for this buffer " << endl;
		return false;
	}

	int x,y;

	img.get_extents (x, y);

	if ((x != m_x) || (y != m_y))
		if (!img.init (m_x, m_y))

		{
			cout << "couldn't allocate the memory needed" << endl;

			return false;
		}

	img.set_data ((byte *) (&(buf [18])));

	return true;
}

bool vuPPM::SaveImage (char* fname)

{
	return false;
}

bool vuPPM::ReadImage (char* fname)

{
	return false;
}

bool vuPPM::OpenImage (char* fname, vuImage &img)

{
	fp = fopen (fname, "r");

	if (fp == NULL)

	{
		cout << "couldn't open: " << fname << endl;
		return false;
	}


	if (!ReadHeader (img))

	{
		cout << "couldn't read the header for; " << fname << endl;
		return false;
	}

	img.init (m_x, m_y);

	counter = 0;

	return true;
}


unsigned int vuPPM::Readnext64KB (vuImage &img)

{
	char rgb [c_64k_];

		// over 60 ms faster to use this than
		// for do fread (3 bytes)
	//fread (rgb, _64k_);

		// 4 ms faster to use this than
		// the for do { for do {...} } loops.
	img.set_rgb ((byte*) (rgb));

	fclose (fp);

	return 0;
}

bool vuPPM::CloseImage ()

{
	return false;
}

bool vuPPM::set_xy (int x, int y)

{
	m_x = x;
	m_y = y;

	return m_Image.init (x, y);
}

int vuPPM::get_x ()

{
	return m_x;
}

int vuPPM::get_y ()

{
	return m_y;
}

inline bool IsSpace (char temp)

{
	return ((temp == ' ') || (temp == '\t') || (temp == '\n'));
}

inline bool IsNumber (char temp)

{
	return ((temp >= '0') && (temp <= '9'));
}

inline bool IsNotNext (char temp)

{
	return ((IsSpace (temp)) || (!IsNumber (temp)));
}

bool vuPPM::WriteHeader (vuImage &img)

{
	char tstring [10];
	char tstring2 [10];

	gcvt (m_x, 4, tstring);

	if (strlen (tstring) > 3)
		return false;

	while (strlen (tstring) < 4)

	{
		strcpy (tstring2, "0");

		strcat (tstring2, tstring);
		strcpy (tstring, tstring2);
	}

	fputs ("P6 ", fp);
	fputs (tstring, fp);
	fputs (" ", fp);

	gcvt (m_y, 4, tstring);

	if (strlen (tstring) > 3)
		return false;

	while (strlen (tstring) < 4)

	{
		strcpy (tstring2, "0");

		strcat (tstring2, tstring);
		strcpy (tstring, tstring2);
	}

	fputs (tstring, fp);
	fputs (" 0255\n", fp);

	return true;
}

int vuPPM::ReadHeader (vuImage &img, char* buf, int readtype)

{
	int retval;

	if (readtype == 1)

	{
		retval = 1;

		if (strncmp ("P6 ", buf, 3))

		{
			retval = 2;

			if (strncmp ("C1 ", buf, 3))
				return 0;
		}

		unsigned char * ubuf = (unsigned char *) (buf);

		m_x = atoi (&(buf [3]));
		m_y = atoi (&(buf [8]));
		m_z = ((ubuf [13] * 256 + ubuf [14]) * 256 + ubuf [15]) * 256 + ubuf [16];

		return retval;
	}

	if (readtype == 0)

	{
		int counter = 0;

		while ((buf [counter] != 'P') && (buf [counter] != '\0'))
			counter++;

		if (buf [counter] == '\0')
			return false;

		if (buf [++counter] != '6')

		{
			cout << "not p6" << endl;
			return false;
		}

		counter++;

		while ((buf [counter] != '\0') && (IsNotNext (buf [counter])))
			counter++;

		while (buf [counter] == '\0')

		{
			if (buf [counter] == EOF)
				return false;

			while ((buf [counter] != '\0') && (IsNotNext (buf [counter])))
				counter++;
		}

		m_x = atoi (&(buf [counter]));

		while ((buf [counter] != '\0') && (IsNumber (buf [counter])))
			counter++;

		while ((buf [counter] != '\0') && (IsNotNext (--buf [counter])))
			counter++;

		while (buf [counter] == '\0')

		{
			if (buf [counter] == EOF)
				return false;

			while ((buf [counter] != '\0') && (IsNotNext (buf [counter])))
				counter++;
		}

		m_y = atoi (&(buf [counter]));

		while ((buf [counter] != '\0') && (IsNumber (buf [counter])))
			counter++;

		while ((buf [counter] != '\0') && (IsNotNext (buf [counter])))
			counter++;

		while (buf [counter] == '\0')

		{
			if (buf [counter] == EOF)
				return false;

			while ((buf [counter] != '\0') && (IsNotNext (buf [counter])))
				counter++;
		}

		return true;
	}

	cout << "Error: readtype not handled" << endl
		<< "readtype = " << readtype << endl;

	return false;
}

int vuPPM::ReadHeader (vuImage &img, int readtype)

{
	int retval;

	if (readtype == 1)

	{
		char c_buf [20];

		fread (c_buf, 1, 18, fp);

		retval = 1;

		if (strncmp ("P6 ", c_buf, 3))

		{
			if (strncmp ("C1 ", c_buf, 3))
				return 0;

			retval = 2;
		}

		unsigned char * ubuf = (unsigned char *) (c_buf);

		m_x = atoi ((char *) (&(ubuf [3])));
		m_y = atoi ((char *) (&(ubuf [8])));
		m_z = ((ubuf [13] * 256 + ubuf [14]) * 256 + ubuf [15]) * 256 + ubuf [16];

		return retval;
	}

	if (readtype == 0)

	{
		char c_buf [126];

		fgets (c_buf, 125, fp);

		int counter = 0;

		while (c_buf [counter] != 'P')

		{
			if (c_buf [counter] == '\n')

			{
				fgets (c_buf, 125, fp);

				counter = -1;

				if (c_buf [counter] == '\0')
					return false;
			}

			counter++;
		}

		if (c_buf [++counter] != '6')

		{
			cout << "not p6" << endl;
			return false;
		}

		counter++;

		while ((c_buf [counter] != '\0') && (IsNotNext (c_buf [counter])))
			counter++;

		while (c_buf [counter] == '\0')

		{
			fgets (c_buf, 125, fp);
			counter = 0;

			if (c_buf [0] == EOF)
				return false;

			while ((c_buf [counter] != '\0') && (IsNotNext (c_buf [counter])))
				counter++;
		}

		m_x = atoi (&(c_buf [counter]));

		while ((c_buf [counter] != '\0') && (IsNumber (c_buf [counter])))
			counter++;

		while ((c_buf [counter] != '\0') && (IsNotNext (c_buf [counter])))
			counter++;

		while (c_buf [counter] == '\0')

		{
			fgets (c_buf, 125, fp);
			counter = 0;

			if (c_buf [0] == EOF)
				return false;

			while ((c_buf [counter] != '\0') && (IsNotNext (c_buf [counter])))
				counter++;
		}

		m_y = atoi (&(c_buf [counter]));

		while ((c_buf [counter] != '\0') && (IsNumber (c_buf [counter])))
			counter++;

		while ((c_buf [counter] != '\0') && (IsNotNext (c_buf [counter])))
			counter++;

		while (c_buf [counter] == '\0')

		{
			fgets (c_buf, 125, fp);
			counter = 0;

			if (c_buf [0] == EOF)
				return false;

			while ((c_buf [counter] != '\0') && (IsNotNext (c_buf [counter])))
				counter++;
		}

		return true;
	}

	cout << "Error: readtype not handled" << endl
		<< "readtype = " << readtype << endl;

	return false;
}



