#ifndef _vuFILEHELPER_H_
#define _vuFILEHELPER_H_

#include "vuString.h"
#include <stdio.h>

class vuFileHelper
{
public:
	/** tries to find the filetype. First the normal vu type is checked and if
	 *  that does not give any result the CG-TUWien dat filetype is tried.
	 */
	static vuString getFileType(const char* filename);
private:
	/** Returns the type of the CG-TUWien file
	 *  (type | geometry | modality | dimensionality | implementation) or 0 if it is invalid. */
	static vuString getdatFileType(const char* filename);
	/** Reads two byte from file and returns the corresponding integer. */
	static int getTwoByte(FILE* file);
	/** returns the type of the file (type | geometry | modality | dimensionality | implementation)
	returns 0 if invalid... */
	static vuString getvuFileType(const char* filename);
	/** '1' if valid header, '\0' otherwise */
	static char getType(FILE *file);
	/** '1' if structured, 
	    '5' if BCC,
	    '6' if Lightfield,
	    '7' if Fourier,
	    '\0' otherwise */
	static char getGeometry(FILE *file);
	/** '1' if unimodal, '2' if multimodal, '\0' otherwise */
	static char getModality(FILE *file);
	/** '1' for 1d, '2' for 2d, '3' for 3d, '\0' otherwise*/
	static char getDimension(FILE *file);
	/** '1' if byte, '2' if word, '3' if dword, '\0' otherwise */
	static char getImplementation(FILE *file);
	/** '1' for Spheric, '\0' otherwise*/
	static char _getKindOfLightfield(FILE *file);
	/** '1' if 1B, '2' if 2B, '3' if 3B,
	    'A' if 1F, 'B' if 2F, 'C' if 3F, '\0' otherwise */
	static char _getFieldsDataType(FILE *file);
};

#endif
