#include "vuFileHelper.h"
#include <string.h>

vuString vuFileHelper::getFileType(const char* filename)
{
	vuString type = getvuFileType(filename);
	if (type.getLength() == 0) {
		type = getdatFileType(filename);
	}
	return type;
}

vuString vuFileHelper::getdatFileType(const char* filename)
{
	FILE* file = fopen(filename, "rb");
	if (file == NULL) return "";
	int i = getTwoByte(file);
	int size = i;
	i = getTwoByte(file);
	size *= i;
	i = getTwoByte(file);
	size *= i;
	size = size*2 + 6;
	fseek(file, 0, SEEK_END);
	int fsize = ftell(file);
	if (fsize >= size) {
		cerr << "Found a CG-TUWien file ...\n";
		return "1112211";
	} else {
		cerr << "Error while checking a CG-TUWien file ...\n";
		return "";
	}
}

int vuFileHelper::getTwoByte(FILE* file)
{
	int result = 0;
	result = result + fgetc(file);
	result = result + (fgetc(file) << 8);
	return result;
}

vuString vuFileHelper::getvuFileType(const char* filename)
{
    FILE *file = fopen(filename,"rb");
    if (file == NULL) return "";

    //Process the file header.
    vuString FileFormat;
    char type = getType(file);
    if (type != '\0')
    {
        FileFormat += type;
        type = getGeometry(file);
    }
    if (type != '\0')
    {
        FileFormat += type;
        type = getModality(file);
    }
    if (type != '\0')
    {
        FileFormat += type;
        type = getDimension(file);
    }
    if (type != '\0')
    {
        FileFormat += type;
        type = getImplementation(file);
    }

    fclose(file);
    
    //Make sure the return type is valid.
    if (type != '\0') FileFormat += type;

    return FileFormat;
}

char vuFileHelper::getType(FILE *file)
{
    int len = 0;
    char header[257];
    //Read in the standard vuVolume header to assert the file type.
    if (( fscanf(file,"# vu DataFile Version 1.0%n",&len) == 0) &&
          (len == 25) && (fgetc(file) == '\n'))
        ;
    else
        return '\0';
    len = 0;

    //Read in the data header
    if ( fgets(header,257,file) == NULL ) return '\0';

    //Read in the format of the file.
    if (( fscanf(file,"ASCII %n",&len) == 0 ) && (len >= 6) )
        ;
    else if (( fscanf(file,"BINARY %n",&len) == 0 ) && (len >= 7) )
        ;
    else 
        return '\0';

    return '1';
}

char vuFileHelper::getGeometry(FILE *file)
{
    int  ret = 0;
    char geometryName[64] = "";

    //Read in the geometry of data
    ret = fscanf(file,"DATASET %s\n", geometryName);
    if (ret != 1) return '\0';

    if      (strcmp(geometryName,"STRUCTURED_POINTS") == 0) return '1';
    else if (strcmp(geometryName,"BCC_POINTS")        == 0) return '5';
    else if (strcmp(geometryName,"LIGHTFIELD")        == 0) return '6';
    else if (strcmp(geometryName,"FOURIER")           == 0) return '7';
    
    return '\0';
}

char vuFileHelper::getModality(FILE *file)
{
    int len = 0;

    //Read in the modality of the data
    if (( fscanf(file,"UNIMODAL %n",&len) == 0) && (len >= 9) )
        return '1';
    else if (( fscanf(file,"MULTIMODAL %n",&len) == 0) && (len >= 11) )
        return '2';
    else
        return '\0';
}

char vuFileHelper::getDimension(FILE *file)
{
    int ret = 0;
    char type;

    //Read in the dimensions of the data
    dword d[4] = {0,0,0,0};
    ret = fscanf(file,"DIMENSIONS %lu %lu %lu %lu ",&d[0],&d[1],&d[2],&d[3]);

    if (ret != 4) // it's probably a lightfield...
      return _getKindOfLightfield(file);

    //Check to see whether this is 2d,3d,or 4d data
    if (d[0]>1 && d[1]>1 && d[2]==1 && d[3]==1)
        type = '1';
    else if (d[0]>1 && d[1]>1 && d[2]>1 && d[3]==1)
        type = '2';
    else if (d[0]>1 && d[1]>1 && d[2]>1 && d[3]>1)
        type = '3';
    else
        return '\0';

    //Read in the origin of the data
    int o[4]={0,0,0,0};
    ret = fscanf(file,"ORIGIN %i %i %i %i ",&o[0],&o[1],&o[2],&o[3]);
    if (ret != 4) return '\0';

    //Read in the spacing of the data
    dword s[4]={0,0,0,0};
    ret = fscanf(file,"SPACING %lu %lu %lu %lu ",&s[0],&s[1],&s[2],&s[3]);
    if (ret != 4) return '\0';
   
    return type;
}

char vuFileHelper::getImplementation(FILE *file)
{
    int len = 0, ret = 0;
    char header[257]="";
    char type;

    //Read in the number of data points stored in the file.
    dword size=0;
    ret = fscanf(file,"POINT_DATA %lu ",&size);
    if (ret != 1) return _getFieldsDataType(file);

    //Read in the name of the data
    ret = fscanf(file,"SCALARS %s ",header);
    if (ret != 1) return '\0';

    //Read in the type of data points
    if (( fscanf(file,"byte %n",&len) == 0) && (len >= 5) )
        type = '1';
    else if (( fscanf(file,"word %n",&len) == 0) && (len >= 5) )
        type = '2';
    else if (( fscanf(file,"dword %n",&len) == 0) && (len >= 6) )
        type = '3';
    else
        return '\0';
    len = 0;

    //Read in the lookup table info
    if (( fscanf(file,"LOOKUP_TABLE default%n",&len) == 0) 
        && (len == 20) && (fgetc(file) == '\n'))
        ;
    else
        return '\0';

    return type;
}

/* ------------------------------------------------------------------------ */
/* --- Additional Lightfield support -------------------------------------- */
/* ------------------------------------------------------------------------ */

char vuFileHelper::_getFieldsDataType(FILE *file)
{
    int ret = 0;

    //Read in the number of data points stored in the file.
    dword size=0;
    ret = fscanf(file,"DATA_SIZE %lu",&size);
    if (ret != 1) return '\0';

    //Read in the type of data points
    char dataName[64] = "";
    char typeName[32] = "";
    int  typeDim      = 0;

    ret = fscanf(file,"\nFIELDS %s %d %s ",dataName, &typeDim, typeName);
    if (ret != 3) return '\0';

    if (strcmp(typeName,"byte") == 0) {
      if      (typeDim == 1) return '1'; // 1B
      else if (typeDim == 2) return '2'; // 2B
      else if (typeDim == 3) return '3'; // 3B
      else                   return '\0';
    }
    else if (strcmp(typeName,"float") == 0) {
      if      (typeDim == 1) return 'A'; // 1F
      else if (typeDim == 2) return 'B'; // 2F
      else if (typeDim == 3) return 'C'; // 3F
      else                   return '\0';
    }
    return '\0';
}

char vuFileHelper::_getKindOfLightfield(FILE *file)
{
  int  ret  = 0;

  //Read in the dimensions of the data
  dword d[3] = {0,0,0};
  ret = fscanf(file,"SPHERIC %lu %lu %lu ",&d[0],&d[1],&d[2]);

  if (ret == 3) return '1'; // it's a spherical lightfield

  return '\0';
}
