#ifndef _VUCOLOURXYZA_H_
#define  _VUCOLOURXYZA_H_

#include "vuSimpleTypes.h"
#include "vuColour.h"

class vuColourRGBa;
class vuColour31a;
class vuColour7a;

#define D65_NORMAL 1056.442   // D65 normalizing luminance

static float CXF31toXYZ[3][31] = 
  {
    {0.014310000000,  0.043510000000, 0.134380000000,  0.283900000000,
     0.348280000000,  0.336200000000, 0.290800000000,  0.195360000000,
     0.095640000000,  0.032010000000, 0.004900000000,  0.009300000000,
     0.063270000000,  0.165500000000, 0.290400000000,  0.433449900000,
     0.594500000000,  0.762100000000, 0.916300000000,  1.026300000000,
     1.062200000000,  1.002600000000, 0.854449900000,  0.642400000000,
     0.447900000000,  0.283500000000, 0.164900000000,  0.087400000000,
     0.046770000000,  0.022700000000, 0.011359160000},
    {0.000396000000,  0.001210000000, 0.004000000000,  0.011600000000,
     0.023000000000,  0.038000000000, 0.060000000000,  0.090980000000,
     0.139020000000,  0.208020000000, 0.323000000000,  0.503000000000,
     0.710000000000,  0.862000000000, 0.954000000000,  0.994950100000,
     0.995000000000,  0.952000000000, 0.870000000000,  0.757000000000,
     0.631000000000,  0.503000000000, 0.381000000000,  0.265000000000,
     0.175000000000,  0.107000000000, 0.061000000000,  0.032000000000,
     0.017000000000,  0.008210000000, 0.004102000000},
    {0.067850010000,  0.207400000000, 0.645600000000,  1.385600000000,
     1.747060000000,  1.772110000000, 1.669200000000,  1.287640000000,
     0.812950100000,  0.465180000000, 0.272000000000,  0.158200000000,
     0.078249990000,  0.042160000000, 0.020300000000,  0.008749999000,
     0.003900000000,  0.002100000000, 0.001650001000,  0.001100000000,
     0.000800000000,  0.000340000000, 0.000190000000,  0.000049999990,
     0.000020000000,  0.000000000000, 0.000000000000,  0.000000000000,
     0.000000000000,  0.000000000000, 0.000000000000 }
};

static float CXF7toXYZ[3][7] = {
  {
     0.14419629,  3.15523510, -5.16978530,
     6.63245620,  1.82661430,  6.40688960, -2.32286750
  },{
    -1.16914350,  0.20485019, 1.78727750,
     7.35206600,  1.73786180, 2.36028410, -1.59273490
  },{
     2.87092470, 18.5172560, -17.5948330,
    17.9091440 ,-23.2460780,  15.3510810, -3.06667750
  }
};

static float CXFRGBtoXYZ[3][3] = {
  {  0.3935,   0.3653,   0.1916 },
  {  0.2124,   0.7011,   0.0866 },
  {  0.0187,   0.1119,   0.9582 }
};

/** Implementation for the XYZ colour model plus alpha channel.
 Derived from vuColour general colour template class. With conversion
 functions from other colour models.
*/
class vuColourXYZa : public vuColour<4>
{
 public:
  /** default constructor */
  vuColourXYZa() : vuColour<4>(), m_Normal(D65_NORMAL) {};
  /** copy constructor */
  vuColourXYZa(const vuColourXYZa& inst) : vuColour<4>(inst), m_Normal(D65_NORMAL)  {};
  /** copy constructor */
  vuColourXYZa(const vuColour<4>& inst) : vuColour<4>(inst), m_Normal(D65_NORMAL)  {};
  /** copy the contents of the array f to the components */
  vuColourXYZa(const float *f) : vuColour<4>(f), m_Normal(D65_NORMAL)  {};
  /** set all components to value of f */
  vuColourXYZa(const float f) : vuColour<4>(f), m_Normal(D65_NORMAL) {};
  /** construct by the given components */
  vuColourXYZa(const float x, const float y, const float z, const float a) : m_Normal(D65_NORMAL)
    {
      m_Data[0] = x; m_Data[1] = y; m_Data[2] = z; m_Data[3] = a;
    }

  /** create an XYZa representation of the given colour */
  vuColourXYZa(const vuColourRGBa& inst) { from(inst); };
  /** create an XYZa representation of the given colour */
  vuColourXYZa(const vuColour7a& inst) { from(inst); };
  /** create an XYZa representation of the given colour */
  vuColourXYZa(const vuColour31a& inst) { from(inst); };

  /** create an XYZa representation of the given colour */
  void from(const vuColourRGBa& rgba)
    {
      fromColourN((vuColour<4>&)rgba, (float*)CXFRGBtoXYZ);
    };

  /** create an XYZa representation of the given colour */
  void from(const vuColour7a& c7a)
    {
      fromColourN((vuColour<8>&)c7a, (const float*)CXF7toXYZ);
    };

  /** create an XYZa representation of the given colour */
  void from(const vuColour31a& c31a)
    {
      fromColourN((vuColour<32>&)c31a, (float*)CXF31toXYZ);
    };

  /** calculates a normalization coefficient
      This is done according to the luminance (Y-component) of the spectrum of the given
      light source.
      \return The normalization factor.
  */
  float setNormalSpectrum(const vuColour31a& s)
    {
      m_Normal = 0;
      for(dword c=0;c<31;c++)
	m_Normal += m_Data[c]*CXF31toXYZ[1][c];
      if(m_Normal == 0) m_Normal = (float)D65_NORMAL;
      return m_Normal;
    };

  /** calculates a normalization coefficient
      This is done according to the luminance (Y-component) of the spectrum of the given
      light source. This version is for the reduced spectrum.
      \return The normalization factor.
  */
  float setNormalSpectrum(const vuColour7a& s)
    {
      m_Normal = 0;
      for(dword c=0;c<7;c++)
	m_Normal += m_Data[c]*CXF7toXYZ[1][c];
      if(m_Normal == 0) m_Normal = (float)D65_NORMAL;
      return m_Normal;
    };

  /** Divides by the normalization coefficient.
      This leads to a luminance of one for a 100% illuminating light source. */
  void normalize(void)
    {
      m_Data[0] /= m_Normal;
      m_Data[1] /= m_Normal;
      m_Data[2] /= m_Normal;
    }

 protected:
  float m_Normal; //!< this is the normal of the colour
};

#endif
