/** \file vuColourXForm.h
 *   This file contains transformation matrices for colour space conversions. 
 *   It is used by vuColourRGBa, vuColourXYZa, vuColour31a, and vuColour7a.
 *   The defined matrices are built for multiplication from right to left.
 */

#ifndef _VUCOLOURXFORM_H_
#define _VUCOLOURXFORM_H_

/** Transform vuColour31a (full spectrum) to vuColour7a. */
static float CXF31to7[7][31] = {
  {
    1.2002231e-01, 1.4073467e-01, 1.4096815e-01, 1.1263114e-01,
    1.0626643e-01, 9.2993271e-02, 6.9433109e-02, 4.4381567e-02,
    2.3690000e-02, 6.2149451e-03, 0.0000000e+00, 3.6648484e-03,
    7.9302968e-03, 1.4693569e-02, 1.5906165e-02, 1.4484020e-02,
    1.0509659e-02, 8.6627655e-03, 9.2364097e-03, 4.2304034e-03,
    0.0000000e+00, 0.0000000e+00, 3.9506079e-04, 6.3332447e-04,
    3.0567183e-03, 6.5464161e-03, 9.8682043e-03, 1.2157955e-02, 
    1.2582588e-02, 8.1060029e-03, 0.0000000e+00
  },{
    0.0000000e+00, 6.5185226e-03, 1.9663932e-02, 3.4135592e-02,
    5.9434493e-02, 8.2437346e-02, 9.6845746e-02, 1.0501623e-01,
    1.1065374e-01, 1.0197605e-01, 8.6785629e-02, 5.9685237e-02,
    3.1977043e-02, 1.3914838e-02, 3.8057357e-03, 1.7769007e-04,
    3.2677888e-04, 0.0000000e+00, 1.6175729e-03, 1.3238266e-02,
    2.5796069e-02, 3.0293402e-02, 2.8430804e-02, 2.2949995e-02,
    1.6393529e-02, 8.2613872e-03, 2.7956703e-03, 0.0000000e+00,
    0.0000000e+00, 7.7654633e-03, 2.9103232e-02
  },{
    3.3822199e-02, 2.7107744e-02, 1.1769212e-02, 0.0000000e+00,
    5.2751063e-03, 1.5562897e-02, 2.4683757e-02, 3.4941433e-02,
    5.2636229e-02, 6.7514950e-02, 8.9435649e-02, 1.0655434e-01,
    1.0898780e-01, 1.0385029e-01, 8.3823686e-02, 6.6251940e-02,
    4.5513451e-02, 2.5497467e-02, 1.1062665e-02, 0.0000000e+00,
    0.0000000e+00, 6.6739476e-04, 1.8066428e-03, 0.0000000e+00,
    3.8082520e-03, 4.9702696e-03, 1.2481071e-02, 2.5221304e-02,
    2.7138986e-02, 9.6152707e-03, 0.0000000e+00
  },{
    0.0000000e+00, 8.7633041e-03, 2.3209989e-02, 2.6204612e-02,
    2.1875648e-02, 1.2010727e-02, 3.7960413e-03, 7.1264066e-04,
    0.0000000e+00, 5.6856235e-03, 1.8981450e-02, 4.3147074e-02,
    7.1665066e-02, 9.7505613e-02, 1.0908012e-01, 1.1256399e-01,
    1.0692711e-01, 9.9948109e-02, 9.0319237e-02, 6.2443765e-02,
    3.5978660e-02, 1.7414736e-02, 6.4102351e-03, 1.8968710e-03,
    0.0000000e+00, 8.3020907e-05, 2.7017146e-04, 0.0000000e+00,
    3.0983801e-03, 8.6533473e-03, 1.1354455e-02
  },{
    9.0700972e-03, 5.7734268e-03, 0.0000000e+00, 0.0000000e+00,
    4.2045100e-03, 1.0315085e-02, 1.4566234e-02, 1.5615907e-02,
    1.3371402e-02, 8.2711135e-03, 3.5818712e-03, 0.0000000e+00,
    2.6421273e-03, 1.2688784e-02, 2.6361042e-02, 4.2134036e-02,
    5.6258719e-02, 6.8834775e-02, 8.0616887e-02, 8.8620047e-02,
    9.7238975e-02, 9.5886654e-02, 8.6737515e-02, 7.4278309e-02,
    6.3171764e-02, 4.6006416e-02, 3.0030269e-02, 1.2651911e-02,
    0.0000000e+00, 4.5688094e-03, 2.6503312e-02
  },{
    2.6018824e-02, 2.0772074e-02, 7.7346765e-03, 0.0000000e+00,
    1.6594244e-03, 6.4943627e-03, 9.0531780e-03, 9.6299359e-03,
    1.0303552e-02, 9.9028742e-03, 1.1838819e-02, 1.0453470e-02,
    4.6030257e-03, 0.0000000e+00, 0.0000000e+00, 6.9064878e-03,
    1.5262097e-02, 2.4237652e-02, 3.6236839e-02, 5.1408105e-02,
    7.2563657e-02, 8.5594325e-02, 9.1085725e-02, 8.8567301e-02,
    9.0759965e-02, 8.4086898e-02, 7.9025435e-02, 7.2232715e-02,
    5.2420387e-02, 2.1148194e-02, 0.0000000e+00
  },{
    0.0000000e+00, 9.6785045e-03, 2.4089121e-02, 2.7182328e-02,
    2.3954977e-02, 1.4941675e-02, 6.0206013e-03, 1.6032588e-03,
    0.0000000e+00, 4.1984497e-03, 1.1135957e-02, 1.9469615e-02,
    2.2616046e-02, 1.9303135e-02, 1.4576435e-02, 9.8628959e-03,
    5.5518575e-03, 2.9655059e-03, 1.7280836e-03, 0.0000000e+00,
    2.1840396e-03, 1.3506427e-02, 3.1153770e-02, 4.8780678e-02,
    6.9310666e-02, 9.0208187e-02, 1.0955650e-01, 1.2723541e-01,
    1.2904578e-01, 1.0168743e-01, 5.8452669e-02
  }
};

static float CXF31toXYZ[3][31] = 
  {
    {0.014310000000,  0.043510000000, 0.134380000000,  0.283900000000,
     0.348280000000,  0.336200000000, 0.290800000000,  0.195360000000,
     0.095640000000,  0.032010000000, 0.004900000000,  0.009300000000,
     0.063270000000,  0.165500000000, 0.290400000000,  0.433449900000,
     0.594500000000,  0.762100000000, 0.916300000000,  1.026300000000,
     1.062200000000,  1.002600000000, 0.854449900000,  0.642400000000,
     0.447900000000,  0.283500000000, 0.164900000000,  0.087400000000,
     0.046770000000,  0.022700000000, 0.011359160000},
    {0.000396000000,  0.001210000000, 0.004000000000,  0.011600000000,
     0.023000000000,  0.038000000000, 0.060000000000,  0.090980000000,
     0.139020000000,  0.208020000000, 0.323000000000,  0.503000000000,
     0.710000000000,  0.862000000000, 0.954000000000,  0.994950100000,
     0.995000000000,  0.952000000000, 0.870000000000,  0.757000000000,
     0.631000000000,  0.503000000000, 0.381000000000,  0.265000000000,
     0.175000000000,  0.107000000000, 0.061000000000,  0.032000000000,
     0.017000000000,  0.008210000000, 0.004102000000},
    {0.067850010000,  0.207400000000, 0.645600000000,  1.385600000000,
     1.747060000000,  1.772110000000, 1.669200000000,  1.287640000000,
     0.812950100000,  0.465180000000, 0.272000000000,  0.158200000000,
     0.078249990000,  0.042160000000, 0.020300000000,  0.008749999000,
     0.003900000000,  0.002100000000, 0.001650001000,  0.001100000000,
     0.000800000000,  0.000340000000, 0.000190000000,  0.000049999990,
     0.000020000000,  0.000000000000, 0.000000000000,  0.000000000000,
     0.000000000000,  0.000000000000, 0.000000000000 }
};

static float CXF31toRGB[3][31] = 
  {
    { 0.00521565, 0.00390937, 0.000723372, 0.00202185, 
      0.00368797, 0.00588572, 0.00590886, 0.00176217, 
      -0.00825111, -0.0201494, -0.0340736, -0.0461601, 
      -0.0481499, -0.0399987, -0.0207983, 0.00123314, 
      0.0239482, 0.0453401, 0.0646684, 0.0808083, 
      0.0940515, 0.0960172, 0.0887535, 0.0775742, 
      0.0662291, 0.0486031, 0.0296983, 0.00697018, 
      -0.0103682, -0.00750403, 0.00952417 
    },{
      -0.00142042, -0.00349118, -0.00500696, -0.00627884, 
      -0.00755297, -0.00802455, -0.00646184, -0.00219459, 
      0.00503255, 0.0142411, 0.0276571, 0.0433701, 0.0561085, 
      0.0645506, 0.0628381, 0.0585545, 0.0499328, 0.0408217, 
      0.0320733, 0.0177956, 0.00710184, -0.000437721, -0.00468562, 
      -0.00701517, -0.00704083, -0.00686325, -0.00473806, 
      -0.000993894, 0.00155751, 0.000141853, -0.000133179 
    },{
      -0.00255871, 0.0155599, 0.0438494, 0.0574821, 0.0668056, 
      0.0663932, 0.0602572, 0.053137, 0.0435271, 0.0311993, 0.0159656, 
      0.00068061, -0.00897285, -0.0124856, -0.00958713, -0.00722662, 
      -0.00376664, -0.000190833, 0.00160625, 0.000773161, -0.00398882, 
      -0.00586364, -0.00554798, -0.00306481, -0.0022702, 0.00114331, 
      0.00185226, 0.000644104, 0.00099772, 0.00264745, -0.00241841 
    }
  };

/** pseudoinverse of CXF31toRGB */
static float CXFRGBto31[31][3] = {
   {  -24.3438,-265.48900, 756.303000 },  { -484.50000,-193.03400, -67.94530 },
   {   27.7031, -68.80950,  -0.601562 },  {   16.65430, -37.09860,  60.44530 },
   {  -89.3311,  24.30050, -48.341900 },  {   46.12300, -36.44880, -25.31450 },
   {  -73.0938,   8.80756,  29.984900 },  {   -7.29688,  38.72270, 255.78000 },
   {  -95.4727, -16.75720,  13.217800 },  {  165.43000, 125.76800, -94.80470 },
   {  220.6840,   8.38141,  10.002000 },  {   56.27150, -21.38200, -46.57280 },
   {  150.9120, -23.47220,  48.887600 },  {  -65.93070,  23.70860, -21.67540 },
   {  -54.9421, 117.42100, -92.961800 },  {   65.48730, -78.52140, 103.69800 },
   { -259.1950, -64.22810,  24.150400 },  {  -21.20900,  -3.61375, -35.69060 },
   {   60.0039, 105.89500,-172.932000 },  {  -76.97850, -14.72780,  -3.99365 },
   {  -13.4766,  32.13540, -52.383800 },  {  -33.18800,  20.05310,   4.97595 },
   {   26.4629, -61.28820,  11.638200 },  {   65.54390,  20.80260, -39.07570 },
   {   13.3853, -79.42970,  23.286600 },  {   32.12110,  56.69430, -59.05220 },
   {  -72.1387, -29.73390,  98.073200 },  {  916.40600,  45.29980,  84.31250 },
   {  -49.7578,  14.61610,  40.484400 },  { -579.84400, -94.20560, 178.49400 },
   {  168.6800, -92.16690, 250.477000 }
};

static float CXF7toXYZ[3][7] = {
  {
     0.14419629,  3.15523510, -5.16978530,
     6.63245620,  1.82661430,  6.40688960, -2.32286750
  },{
    -1.16914350,  0.20485019, 1.78727750,
     7.35206600,  1.73786180, 2.36028410, -1.59273490
  },{
     2.87092470, 18.5172560, -17.5948330,
    17.9091440 ,-23.2460780,  15.3510810, -3.06667750
  }
};

static float CXFXYZtoRGB[3][3] = {
  {  3.5058f, -1.7397f, -0.5440f  },
  { -1.0690f,  1.9778f,  0.0352f  },
  {  0.0563f, -0.1970f,  1.0501f  }
};

static float CXFRGBtoXYZ[3][3] = {
  {  0.3935,   0.3653,   0.1916 },
  {  0.2124,   0.7011,   0.0866 },
  {  0.0187,   0.1119,   0.9582 }
};

static float CXF7toRGB[3][7] = {
  {  0.977699,  0.631857, -11.661971,  0.719102,  16.026253, 10.004099, -3.704355 },
  { -2.365421, -2.315986,   8.442040,  8.081223,   0.666230, -1.640437, -0.774913 },
  {  3.253197, 19.582254, -19.119486, 17.731441, -24.650227, 16.015902, -3.037327 }
};

#endif
